/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;

public class PerTableRoutingConfig {
    private static final String NUM_NODES_PER_REPLICA = "numNodesPerReplica";
    private static final String SERVERS_FOR_NODE = "serversForNode";
    private static final String DEFAULT_SERVERS_FOR_NODE = "default";
    private final Configuration _tableCfg;
    private int _numNodes;
    private List<String> _defaultServers;
    private final Map<Integer, List<String>> _nodeToInstancesMap;

    public PerTableRoutingConfig(Configuration cfg) {
        this._tableCfg = cfg;
        this._nodeToInstancesMap = new HashMap<Integer, List<String>>();
        this._defaultServers = new ArrayList<String>();
        this.loadConfig();
    }

    private void loadConfig() {
        if (null == this._tableCfg) {
            return;
        }
        this._nodeToInstancesMap.clear();
        this._numNodes = this._tableCfg.getInt(NUM_NODES_PER_REPLICA);
        for (int i = 0; i < this._numNodes; ++i) {
            this._nodeToInstancesMap.put(i, this._tableCfg.getList(this.getKey(SERVERS_FOR_NODE, Integer.toString(i))));
        }
        this._defaultServers = this._tableCfg.getList(this.getKey(SERVERS_FOR_NODE, DEFAULT_SERVERS_FOR_NODE));
    }

    private String getKey(String prefix, String suffix) {
        String s = prefix + "." + suffix;
        return s;
    }

    public int getNumNodes() {
        return this._numNodes;
    }

    public List<String> getDefaultServers() {
        return this._defaultServers;
    }

    public Map<String, List<String>> buildRequestRoutingMap() {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        for (String serverName : this._defaultServers) {
            resultMap.put(serverName, Collections.singletonList(DEFAULT_SERVERS_FOR_NODE));
        }
        return resultMap;
    }

    public Map<Integer, List<String>> getNodeToInstancesMap() {
        return this._nodeToInstancesMap;
    }

    public String toString() {
        return "PerTableRoutingConfig [_tableCfg=" + this._tableCfg + ", _numNodes=" + this._numNodes + ", _defaultServers=" + this._defaultServers + ", _nodeToInstancesMap=" + this._nodeToInstancesMap + "]";
    }
}

