/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.metrics;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.pinot.$internal.com.yammer.metrics.core.Sampling;
import org.apache.pinot.$internal.com.yammer.metrics.core.Summarizable;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.PoolStats;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.PoolStatsProvider;
import org.apache.pinot.common.metrics.AggregatedHistogram;
import org.apache.pinot.common.metrics.LatencyMetric;

public class AggregatedPoolStats<T extends Sampling & Summarizable>
implements PoolStats<T>,
PoolStatsProvider {
    private final long DEFAULT_REFRESH_MS = 60000L;
    private final long _refreshMs;
    private volatile long _lastRefreshedTime;
    private volatile int _totalCreated;
    private volatile int _totalDestroyed;
    private volatile int _totalCreateErrors;
    private volatile int _totalDestroyErrors;
    private volatile int _totalBadDestroyed;
    private volatile int _totalTimedOut;
    private volatile int _checkedOut;
    private volatile int _maxPoolSize;
    private volatile int _minPoolSize;
    private volatile int _poolSize;
    private volatile int _sampleMaxCheckedOut;
    private volatile int _sampleMaxPoolSize;
    private volatile int _idleCount;
    private volatile LatencyMetric<T> _waitTime;
    private volatile PoolStats.LifecycleStats<T> _lifecycleStats;
    private final List<PoolStatsProvider> _poolStatsProvider = new CopyOnWriteArrayList<PoolStatsProvider>();

    public AggregatedPoolStats(long refreshMs) {
        this._refreshMs = refreshMs;
    }

    public AggregatedPoolStats() {
        this._refreshMs = 60000L;
    }

    public AggregatedPoolStats<T> addAll(Collection<PoolStatsProvider> poolStats) {
        this._poolStatsProvider.addAll(poolStats);
        return this;
    }

    public AggregatedPoolStats<T> add(PoolStatsProvider poolStat) {
        this._poolStatsProvider.add(poolStat);
        return this;
    }

    public void refreshIfElapsed() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this._lastRefreshedTime > this._refreshMs && !this._poolStatsProvider.isEmpty()) {
            this.refresh();
            this._lastRefreshedTime = currentTime;
        }
    }

    @Override
    public void refresh() {
        int totalCreated = 0;
        int totalDestroyed = 0;
        int totalCreateErrors = 0;
        int totalDestroyErrors = 0;
        int totalBadDestroyed = 0;
        int totalTimedOut = 0;
        int checkedOut = 0;
        int maxPoolSize = 0;
        int minPoolSize = 0;
        int poolSize = 0;
        int sampleMaxCheckedOut = 0;
        int sampleMaxPoolSize = 0;
        int idleCount = 0;
        AggregatedHistogram waitTimeHist = new AggregatedHistogram();
        AggregatedHistogram createTimeHist = new AggregatedHistogram();
        for (PoolStatsProvider p : this._poolStatsProvider) {
            PoolStats s = p.getStats();
            totalCreated += s.getTotalCreated();
            totalDestroyed += s.getTotalBadDestroyed();
            totalCreateErrors += s.getTotalCreateErrors();
            totalDestroyErrors += s.getTotalDestroyErrors();
            totalBadDestroyed += s.getTotalBadDestroyed();
            totalTimedOut += s.getTotalTimedOut();
            checkedOut += s.getCheckedOut();
            maxPoolSize += s.getMaxPoolSize();
            minPoolSize += s.getMinPoolSize();
            poolSize += s.getPoolSize();
            sampleMaxCheckedOut += s.getSampleMaxCheckedOut();
            sampleMaxPoolSize += s.getSampleMaxPoolSize();
            idleCount += s.getIdleCount();
            waitTimeHist.add(s.getWaitTime().getHistogram());
            createTimeHist.add(s.getLifecycleStats().getCreateTime().getHistogram());
        }
        this._totalCreated = totalCreated;
        this._totalDestroyed = totalDestroyed;
        this._totalBadDestroyed = totalBadDestroyed;
        this._totalCreateErrors = totalCreateErrors;
        this._totalDestroyErrors = totalDestroyErrors;
        this._totalTimedOut = totalTimedOut;
        this._checkedOut = checkedOut;
        this._maxPoolSize = maxPoolSize;
        this._minPoolSize = minPoolSize;
        this._poolSize = poolSize;
        this._sampleMaxCheckedOut = sampleMaxCheckedOut;
        this._sampleMaxPoolSize = sampleMaxPoolSize;
        this._idleCount = idleCount;
        this._waitTime = new LatencyMetric(waitTimeHist);
        this._lifecycleStats = new PoolStats.LifecycleStats(new LatencyMetric(createTimeHist));
    }

    @Override
    public int getTotalCreated() {
        this.refreshIfElapsed();
        return this._totalCreated;
    }

    @Override
    public int getTotalDestroyed() {
        this.refreshIfElapsed();
        return this._totalDestroyed;
    }

    @Override
    public int getTotalCreateErrors() {
        this.refreshIfElapsed();
        return this._totalCreateErrors;
    }

    @Override
    public int getTotalDestroyErrors() {
        this.refreshIfElapsed();
        return this._totalDestroyErrors;
    }

    @Override
    public int getTotalBadDestroyed() {
        this.refreshIfElapsed();
        return this._totalBadDestroyed;
    }

    @Override
    public int getTotalTimedOut() {
        this.refreshIfElapsed();
        return this._totalTimedOut;
    }

    @Override
    public int getCheckedOut() {
        this.refreshIfElapsed();
        return this._checkedOut;
    }

    @Override
    public int getMaxPoolSize() {
        this.refreshIfElapsed();
        return this._maxPoolSize;
    }

    @Override
    public int getMinPoolSize() {
        this.refreshIfElapsed();
        return this._minPoolSize;
    }

    @Override
    public int getPoolSize() {
        this.refreshIfElapsed();
        return this._poolSize;
    }

    @Override
    public int getSampleMaxCheckedOut() {
        this.refreshIfElapsed();
        return this._sampleMaxCheckedOut;
    }

    @Override
    public int getSampleMaxPoolSize() {
        this.refreshIfElapsed();
        return this._sampleMaxPoolSize;
    }

    @Override
    public int getIdleCount() {
        this.refreshIfElapsed();
        return this._idleCount;
    }

    @Override
    public LatencyMetric<T> getWaitTime() {
        this.refreshIfElapsed();
        return this._waitTime;
    }

    @Override
    public PoolStats.LifecycleStats<T> getLifecycleStats() {
        this.refreshIfElapsed();
        return this._lifecycleStats;
    }

    @Override
    public PoolStats<T> getStats() {
        return this;
    }

    @Override
    public String toString() {
        return "AggregatedPoolStats [_refreshMs=" + this._refreshMs + ", _lastRefreshedTime=" + this._lastRefreshedTime + ", _totalCreated=" + this._totalCreated + ", _totalDestroyed=" + this._totalDestroyed + ", _totalCreateErrors=" + this._totalCreateErrors + ", _totalDestroyErrors=" + this._totalDestroyErrors + ", _totalBadDestroyed=" + this._totalBadDestroyed + ", _totalTimedOut=" + this._totalTimedOut + ", _checkedOut=" + this._checkedOut + ", _maxPoolSize=" + this._maxPoolSize + ", _minPoolSize=" + this._minPoolSize + ", _poolSize=" + this._poolSize + ", _sampleMaxCheckedOut=" + this._sampleMaxCheckedOut + ", _sampleMaxPoolSize=" + this._sampleMaxPoolSize + ", _idleCount=" + this._idleCount + ", _waitTime=" + this._waitTime + ", _lifecycleStats=" + this._lifecycleStats + ", _poolStatsProvider=" + this._poolStatsProvider + "]";
    }
}

