/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.metrics;

import org.apache.pinot.$internal.com.yammer.metrics.core.Gauge;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricName;
import org.apache.pinot.$internal.com.yammer.metrics.core.Sampling;
import org.apache.pinot.$internal.com.yammer.metrics.core.Summarizable;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.NettyClientMetrics;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.TransportClientMetrics;
import org.apache.pinot.common.metrics.AggregatedCounter;
import org.apache.pinot.common.metrics.AggregatedHistogram;
import org.apache.pinot.common.metrics.AggregatedLongGauge;
import org.apache.pinot.common.metrics.AggregatedMetricsRegistry;
import org.apache.pinot.common.metrics.LatencyMetric;
import org.apache.pinot.common.metrics.MetricsHelper;

public class AggregatedTransportClientMetrics
implements TransportClientMetrics {
    public static final String CONNECT_TIME = "CONNECT-MS";
    public static final String REQUESTS_SENT = "Requests-Sent";
    public static final String BYTES_SENT = "bytes-Sent";
    public static final String BYTES_RECEIVED = "bytes-received";
    public static final String ERRORS = "errors";
    public static final String SEND_REQUEST_MS = "Send-Request-MS";
    public static final String RESPONSE_LATENCY_MS = "Latency-MS";
    private final AggregatedCounter _requestsSent;
    private final AggregatedCounter _bytesSent;
    private final AggregatedCounter _bytesReceived;
    private final AggregatedCounter _errors;
    private final AggregatedHistogram<Sampling> _sendRequestMsHistogram;
    private final AggregatedHistogram<Sampling> _responseLatencyMsHistogram;
    private final AggregatedLongGauge<Long, Gauge<Long>> _connectMsGauge;

    public AggregatedTransportClientMetrics(AggregatedMetricsRegistry registry, String group) {
        this._requestsSent = MetricsHelper.newAggregatedCounter(registry, new MetricName(group, "", REQUESTS_SENT));
        this._bytesSent = MetricsHelper.newAggregatedCounter(registry, new MetricName(group, "", BYTES_SENT));
        this._bytesReceived = MetricsHelper.newAggregatedCounter(registry, new MetricName(group, "", BYTES_RECEIVED));
        this._errors = MetricsHelper.newAggregatedCounter(registry, new MetricName(group, "", ERRORS));
        this._sendRequestMsHistogram = MetricsHelper.newAggregatedHistogram(registry, new MetricName(group, "", SEND_REQUEST_MS));
        this._responseLatencyMsHistogram = MetricsHelper.newAggregatedHistogram(registry, new MetricName(group, "", RESPONSE_LATENCY_MS));
        this._connectMsGauge = MetricsHelper.newAggregatedLongGauge(registry, new MetricName(group, "", CONNECT_TIME));
    }

    public void addTransportClientMetrics(NettyClientMetrics metric) {
        this._requestsSent.add(metric.getRequestsSent());
        this._bytesSent.add(metric.getBytesSent());
        this._bytesReceived.add(metric.getBytesReceived());
        this._errors.add(metric.getErrors());
        this._connectMsGauge.add(metric.getConnectMsGauge());
        this._sendRequestMsHistogram.add(metric.getSendRequestMsHistogram());
        this._responseLatencyMsHistogram.add(metric.getResponseLatencyMsHistogram());
    }

    public void addTransportClientMetrics(AggregatedTransportClientMetrics metric) {
        this._requestsSent.add(metric.getRequestsSent());
        this._bytesSent.add(metric.getBytesSent());
        this._bytesReceived.add(metric.getBytesReceived());
        this._errors.add(metric.getErrors());
        this._connectMsGauge.add(metric.getConnectMsGauge());
        this._sendRequestMsHistogram.add(metric.getSendRequestMsHistogram());
        this._responseLatencyMsHistogram.add(metric.getResponseLatencyMsHistogram());
    }

    public void removeTransportClientMetrics(NettyClientMetrics metric) {
        this._requestsSent.remove(metric.getRequestsSent());
        this._bytesSent.remove(metric.getBytesSent());
        this._bytesReceived.remove(metric.getBytesReceived());
        this._errors.remove(metric.getErrors());
        this._connectMsGauge.remove(metric.getConnectMsGauge());
        this._sendRequestMsHistogram.remove(metric.getSendRequestMsHistogram());
        this._responseLatencyMsHistogram.remove(metric.getResponseLatencyMsHistogram());
    }

    public void removeTransportClientMetrics(AggregatedTransportClientMetrics metric) {
        this._requestsSent.remove(metric.getRequestsSent());
        this._bytesSent.remove(metric.getBytesSent());
        this._bytesReceived.remove(metric.getBytesReceived());
        this._errors.remove(metric.getErrors());
        this._connectMsGauge.remove(metric.getConnectMsGauge());
        this._sendRequestMsHistogram.remove(metric.getSendRequestMsHistogram());
        this._responseLatencyMsHistogram.remove(metric.getResponseLatencyMsHistogram());
    }

    @Override
    public long getTotalRequests() {
        return this._requestsSent.count();
    }

    @Override
    public long getTotalBytesSent() {
        return this._bytesSent.count();
    }

    @Override
    public long getTotalBytesReceived() {
        return this._bytesReceived.count();
    }

    @Override
    public long getTotalErrors() {
        return this._errors.count();
    }

    @Override
    public <T extends Sampling & Summarizable> LatencyMetric<T> getSendRequestLatencyMs() {
        return new LatencyMetric<AggregatedHistogram<Sampling>>(this._sendRequestMsHistogram);
    }

    @Override
    public <T extends Sampling & Summarizable> LatencyMetric<T> getResponseLatencyMs() {
        return new LatencyMetric<AggregatedHistogram<Sampling>>(this._responseLatencyMsHistogram);
    }

    @Override
    public long getConnectTimeMs() {
        return this._connectMsGauge.value();
    }

    private AggregatedCounter getRequestsSent() {
        return this._requestsSent;
    }

    private AggregatedCounter getBytesSent() {
        return this._bytesSent;
    }

    private AggregatedCounter getBytesReceived() {
        return this._bytesReceived;
    }

    private AggregatedCounter getErrors() {
        return this._errors;
    }

    private AggregatedHistogram<Sampling> getSendRequestMsHistogram() {
        return this._sendRequestMsHistogram;
    }

    private AggregatedHistogram<Sampling> getResponseLatencyMsHistogram() {
        return this._responseLatencyMsHistogram;
    }

    private AggregatedLongGauge<Long, Gauge<Long>> getConnectMsGauge() {
        return this._connectMsGauge;
    }
}

