/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.metrics;

import org.apache.pinot.$internal.com.yammer.metrics.core.Counter;
import org.apache.pinot.$internal.com.yammer.metrics.core.Histogram;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricName;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricsRegistry;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.TransportServerMetrics;
import org.apache.pinot.common.metrics.LatencyMetric;
import org.apache.pinot.common.metrics.MetricsHelper;

public class NettyServerMetrics
implements TransportServerMetrics {
    public static final String REQUESTS_RECEIVED = "Requests-Sent";
    public static final String BYTES_SENT = "bytes-Sent";
    public static final String BYTES_RECEIVED = "bytes-received";
    public static final String SEND_RESPONSE_MS = "Send-Response-MS";
    public static final String PROCESSING_LATENCY_MS = "Processing-Latency-MS";
    public static final String ERRORS = "errors";
    private final Counter _requestsReceived;
    private final Counter _bytesSent;
    private final Counter _bytesReceived;
    private final Counter _errors;
    private final Histogram _sendResponseMsHistogram;
    private final Histogram _processingLatencyMsHistogram;

    public NettyServerMetrics(MetricsRegistry registry, String group) {
        this._requestsReceived = MetricsHelper.newCounter(registry, new MetricName(group, "", REQUESTS_RECEIVED));
        this._bytesSent = MetricsHelper.newCounter(registry, new MetricName(group, "", BYTES_SENT));
        this._bytesReceived = MetricsHelper.newCounter(registry, new MetricName(group, "", BYTES_RECEIVED));
        this._errors = MetricsHelper.newCounter(registry, new MetricName(group, "", ERRORS));
        this._sendResponseMsHistogram = MetricsHelper.newHistogram(registry, new MetricName(group, "", SEND_RESPONSE_MS), false);
        this._processingLatencyMsHistogram = MetricsHelper.newHistogram(registry, new MetricName(group, "", PROCESSING_LATENCY_MS), false);
    }

    public void addServingStats(long requestSize, long responseSize, long numRequests, boolean error, long processingLatencyMs, long sendResponseLatencyMs) {
        this._requestsReceived.inc(numRequests);
        this._bytesReceived.inc(requestSize);
        this._bytesSent.inc(responseSize);
        if (error) {
            this._errors.inc();
        }
        this._sendResponseMsHistogram.update(sendResponseLatencyMs);
        this._processingLatencyMsHistogram.update(processingLatencyMs);
    }

    public Counter getRequestsReceived() {
        return this._requestsReceived;
    }

    public Counter getBytesSent() {
        return this._bytesSent;
    }

    public Counter getBytesReceived() {
        return this._bytesReceived;
    }

    public Counter getErrors() {
        return this._errors;
    }

    public Histogram getSendResponseMsHistogram() {
        return this._sendResponseMsHistogram;
    }

    public Histogram getProcessingLatencyMsHistogram() {
        return this._processingLatencyMsHistogram;
    }

    public String toString() {
        return "NettyServerMetric [_requestsReceived=" + this._requestsReceived.count() + ", _bytesSent=" + this._bytesSent.count() + ", _bytesReceived=" + this._bytesReceived.count() + ", _errors=" + this._errors.count() + ", _sendResponseMsGauge=" + this._sendResponseMsHistogram.count() + ", _processingLatencyMsGauge=" + this._processingLatencyMsHistogram.count() + "]";
    }

    @Override
    public long getTotalRequests() {
        return this._requestsReceived.count();
    }

    @Override
    public long getTotalBytesSent() {
        return this._bytesSent.count();
    }

    @Override
    public long getTotalBytesReceived() {
        return this._bytesReceived.count();
    }

    @Override
    public long getTotalErrors() {
        return this._errors.count();
    }

    public LatencyMetric<Histogram> getSendResponseLatencyMs() {
        return new LatencyMetric<Histogram>(this._sendResponseMsHistogram);
    }

    public LatencyMetric<Histogram> getProcessingLatencyMs() {
        return new LatencyMetric<Histogram>(this._processingLatencyMsHistogram);
    }
}

