/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.netty;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.com.google.common.util.concurrent.FutureCallback;
import org.apache.pinot.$internal.com.google.common.util.concurrent.Futures;
import org.apache.pinot.$internal.com.google.common.util.concurrent.ListenableFuture;
import org.apache.pinot.$internal.io.netty.bootstrap.ServerBootstrap;
import org.apache.pinot.$internal.io.netty.buffer.ByteBuf;
import org.apache.pinot.$internal.io.netty.buffer.Unpooled;
import org.apache.pinot.$internal.io.netty.channel.Channel;
import org.apache.pinot.$internal.io.netty.channel.ChannelFuture;
import org.apache.pinot.$internal.io.netty.channel.ChannelFutureListener;
import org.apache.pinot.$internal.io.netty.channel.ChannelHandlerContext;
import org.apache.pinot.$internal.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.pinot.$internal.io.netty.channel.EventLoopGroup;
import org.apache.pinot.$internal.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.pinot.$internal.io.netty.util.concurrent.Future;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.AggregatedTransportServerMetrics;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.NettyServerMetrics;
import org.apache.pinot.common.metrics.AggregatedMetricsRegistry;
import org.apache.pinot.common.metrics.MetricsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NettyServer
implements Runnable {
    protected static Logger LOGGER = LoggerFactory.getLogger(NettyServer.class);
    public static final String AGGREGATED_SERVER_METRICS_NAME = "Server_Global_Metric_";
    protected int _port;
    protected AtomicBoolean _shutdownComplete = new AtomicBoolean(false);
    protected final EventLoopGroup _bossGroup;
    protected final EventLoopGroup _workerGroup;
    protected volatile Channel _channel = null;
    protected RequestHandlerFactory _handlerFactory;
    protected final AggregatedMetricsRegistry _metricsRegistry;
    protected final AggregatedTransportServerMetrics _metrics;
    protected final long _defaultLargeQueryLatencyMs;

    public NettyServer(int port, RequestHandlerFactory handlerFactory, AggregatedMetricsRegistry registry, long defaultLargeQueryLatencyMs) {
        this(port, handlerFactory, registry, defaultLargeQueryLatencyMs, 1, 20);
    }

    public NettyServer(int port, RequestHandlerFactory handlerFactory, AggregatedMetricsRegistry registry, long defaultLargeQueryLatencyMs, int numThreadsForBossGroup, int numThreadsForWorkerGroup) {
        this._port = port;
        this._handlerFactory = handlerFactory;
        this._metricsRegistry = registry;
        this._metrics = new AggregatedTransportServerMetrics(this._metricsRegistry, AGGREGATED_SERVER_METRICS_NAME + port + "_");
        this._defaultLargeQueryLatencyMs = defaultLargeQueryLatencyMs;
        this._bossGroup = new NioEventLoopGroup(numThreadsForBossGroup);
        this._workerGroup = new NioEventLoopGroup(numThreadsForWorkerGroup);
    }

    @Override
    public void run() {
        try {
            ServerBootstrap bootstrap = this.getServerBootstrap();
            LOGGER.info("Binding to the server port !!");
            ChannelFuture f = bootstrap.bind(this._port).sync();
            this._channel = f.channel();
            LOGGER.info("Server bounded to port :" + this._port + ", Waiting for closing");
            f.channel().closeFuture().sync();
            LOGGER.info("Server boss channel is closed. Gracefully shutting down the server netty threads and pipelines");
        }
        catch (Exception e) {
            LOGGER.error("Got exception in the main server thread. Stopping !!", (Throwable)e);
        }
        finally {
            this._shutdownComplete.set(true);
        }
    }

    protected abstract ServerBootstrap getServerBootstrap();

    public boolean isStarted() {
        return this._channel != null;
    }

    public void shutdownGracefully() {
        LOGGER.info("Shutdown requested in the server !!");
        if (null != this._channel) {
            LOGGER.info("Closing the server channel");
            this._channel.close();
            this._bossGroup.shutdownGracefully();
            this._workerGroup.shutdownGracefully();
        }
    }

    public void waitForShutdown(long millis) {
        LOGGER.info("Waiting for Shutdown");
        if (this._channel != null) {
            LOGGER.info("Closing the server channel");
            long endTime = System.currentTimeMillis() + millis;
            ChannelFuture channelFuture = this._channel.close();
            Future<?> bossGroupFuture = this._bossGroup.shutdownGracefully();
            Future<?> workerGroupFuture = this._workerGroup.shutdownGracefully();
            long currentTime = System.currentTimeMillis();
            if (endTime > currentTime) {
                channelFuture.awaitUninterruptibly(endTime - currentTime, TimeUnit.MILLISECONDS);
            }
            if (endTime > (currentTime = System.currentTimeMillis())) {
                bossGroupFuture.awaitUninterruptibly(endTime - currentTime, TimeUnit.MILLISECONDS);
            }
            if (endTime > (currentTime = System.currentTimeMillis())) {
                workerGroupFuture.awaitUninterruptibly(endTime - currentTime, TimeUnit.MILLISECONDS);
            }
            Preconditions.checkState(channelFuture.isDone(), "Unable to close the channel in %s ms", millis);
            Preconditions.checkState(bossGroupFuture.isDone(), "Unable to shutdown the boss group in %s ms", millis);
            Preconditions.checkState(workerGroupFuture.isDone(), "Unable to shutdown the worker group in %s ms", millis);
        }
    }

    public boolean isShutdownComplete() {
        return this._shutdownComplete.get();
    }

    public static class NettyChannelInboundHandler
    extends ChannelInboundHandlerAdapter {
        private final long _defaultLargeQueryLatencyMs;
        private final RequestHandler _handler;
        private final NettyServerMetrics _metric;

        public NettyChannelInboundHandler(RequestHandler handler, NettyServerMetrics metric, long defaultLargeQueryLatencyMs) {
            this._handler = handler;
            this._metric = metric;
            this._defaultLargeQueryLatencyMs = defaultLargeQueryLatencyMs;
        }

        public NettyChannelInboundHandler(RequestHandler handler, NettyServerMetrics metric) {
            this(handler, metric, 100L);
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            final long requestStartTime = System.currentTimeMillis();
            LOGGER.debug("Request received by server !!");
            final ByteBuf request = (ByteBuf)msg;
            final long requestSizeInBytes = request.readableBytes();
            final MetricsHelper.TimerContext requestProcessingLatency = MetricsHelper.startTimer();
            final ChannelHandlerContext requestChannelHandlerContext = ctx;
            ListenableFuture<byte[]> serializedQueryResponse = this._handler.processRequest(ctx, request);
            Futures.addCallback(serializedQueryResponse, (FutureCallback)new FutureCallback<byte[]>(){

                void sendResponse(final @Nonnull byte[] result) {
                    requestProcessingLatency.stop();
                    ByteBuf responseBuf = Unpooled.wrappedBuffer(result);
                    final MetricsHelper.TimerContext responseSendLatency = MetricsHelper.startTimer();
                    ChannelFuture f = requestChannelHandlerContext.writeAndFlush(responseBuf);
                    f.addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture future) throws Exception {
                            LOGGER.debug("Response has been sent !!");
                            responseSendLatency.stop();
                            _metric.addServingStats(requestSizeInBytes, result.length, 1L, false, requestProcessingLatency.getLatencyMs(), responseSendLatency.getLatencyMs());
                            long totalQueryTime = System.currentTimeMillis() - requestStartTime;
                            if (totalQueryTime > _defaultLargeQueryLatencyMs) {
                                LOGGER.info("Slow query: request handler processing time: {}, send response latency: {}, total time to handle request: {}", new Object[]{requestProcessingLatency.getLatencyMs(), responseSendLatency.getLatencyMs(), totalQueryTime});
                            }
                        }
                    });
                    request.release();
                }

                @Override
                public void onSuccess(@Nullable byte[] result) {
                    if (result == null) {
                        result = new byte[]{};
                    }
                    this.sendResponse(result);
                }

                @Override
                public void onFailure(Throwable t) {
                    LOGGER.error("Request processing returned unhandled exception, error: ", t);
                    this.sendResponse(new byte[0]);
                }
            });
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            LOGGER.error("Got exception in the channel handler", cause);
            this._metric.addServingStats(0L, 0L, 0L, true, 0L, 0L);
            ctx.close();
        }

        public String toString() {
            return "NettyChannelInboundHandler [_handler=" + this._handler + ", _metric=" + this._metric + "]";
        }
    }

    public static interface RequestHandlerFactory {
        public RequestHandler createNewRequestHandler();
    }

    public static interface RequestHandler {
        public ListenableFuture<byte[]> processRequest(ChannelHandlerContext var1, ByteBuf var2);
    }
}

