/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.netty;

import org.apache.pinot.$internal.com.yammer.metrics.core.MetricsRegistry;
import org.apache.pinot.$internal.io.netty.bootstrap.ServerBootstrap;
import org.apache.pinot.$internal.io.netty.channel.ChannelHandler;
import org.apache.pinot.$internal.io.netty.channel.ChannelInitializer;
import org.apache.pinot.$internal.io.netty.channel.ChannelOption;
import org.apache.pinot.$internal.io.netty.channel.socket.SocketChannel;
import org.apache.pinot.$internal.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.pinot.$internal.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.pinot.$internal.io.netty.handler.codec.LengthFieldPrepender;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.AggregatedTransportServerMetrics;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.NettyServerMetrics;
import org.apache.pinot.$internal.org.apache.pinot.transport.netty.NettyServer;
import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metrics.AggregatedMetricsRegistry;

public class NettyTCPServer
extends NettyServer {
    public NettyTCPServer(int port, NettyServer.RequestHandlerFactory handlerFactory, AggregatedMetricsRegistry registry, long defaultLargeQueryLatencyMs) {
        super(port, handlerFactory, registry, defaultLargeQueryLatencyMs);
    }

    public NettyTCPServer(int port, NettyServer.RequestHandlerFactory handlerFactory, AggregatedMetricsRegistry registry) {
        this(port, handlerFactory, registry, 100L);
    }

    public NettyTCPServer(int port, NettyServer.RequestHandlerFactory handlerFactory, AggregatedMetricsRegistry registry, long defaultLargeQueryLatencyMs, int numThreadsForBossGroup, int numThreadsForWorkerGroup) {
        super(port, handlerFactory, registry, defaultLargeQueryLatencyMs, numThreadsForBossGroup, numThreadsForWorkerGroup);
    }

    @Override
    protected ServerBootstrap getServerBootstrap() {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this._bossGroup, this._workerGroup).channel(NioServerSocketChannel.class)).childHandler(this.createChannelInitializer()).option(ChannelOption.SO_BACKLOG, 128)).childOption(ChannelOption.SO_KEEPALIVE, true);
        return b;
    }

    protected ChannelInitializer<SocketChannel> createChannelInitializer() {
        return new ServerChannelInitializer(this._handlerFactory, this._metricsRegistry, this._metrics, this._defaultLargeQueryLatencyMs);
    }

    protected static class ServerChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private final NettyServer.RequestHandlerFactory _handlerFactory;
        private final MetricsRegistry _registry;
        private final AggregatedTransportServerMetrics _globalMetrics;
        private final long _defaultLargeQueryLatencyMs;

        public ServerChannelInitializer(NettyServer.RequestHandlerFactory handlerFactory, MetricsRegistry registry, AggregatedTransportServerMetrics globalMetrics, long defaultLargeQueryLatencyMs) {
            this._handlerFactory = handlerFactory;
            this._registry = registry;
            this._globalMetrics = globalMetrics;
            this._defaultLargeQueryLatencyMs = defaultLargeQueryLatencyMs;
        }

        public ServerChannelInitializer(NettyServer.RequestHandlerFactory handlerFactory, MetricsRegistry registry, AggregatedTransportServerMetrics globalMetrics) {
            this(handlerFactory, registry, globalMetrics, 100L);
        }

        @Override
        protected void initChannel(SocketChannel ch) throws Exception {
            NettyServer.LOGGER.info("Setting up Server channel, scheduler");
            ch.pipeline().addLast("decoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4));
            ch.pipeline().addLast("encoder", (ChannelHandler)new LengthFieldPrepender(4));
            NettyServerMetrics serverMetric = new NettyServerMetrics(this._registry, NettyTCPServer.class.getName() + "_" + Utils.getUniqueId() + "_");
            if (null != this._globalMetrics) {
                this._globalMetrics.addTransportClientMetrics(serverMetric);
            }
            ch.pipeline().addLast("request_handler", (ChannelHandler)new NettyServer.NettyChannelInboundHandler(this._handlerFactory.createNewRequestHandler(), serverMetric, this._defaultLargeQueryLatencyMs));
        }
    }
}

