/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.netty;

import org.apache.pinot.$internal.io.netty.channel.EventLoopGroup;
import org.apache.pinot.$internal.io.netty.util.Timer;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.Callback;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.NoneType;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.NettyClientMetrics;
import org.apache.pinot.$internal.org.apache.pinot.transport.netty.NettyTCPClientConnection;
import org.apache.pinot.$internal.org.apache.pinot.transport.pool.KeyedPool;
import org.apache.pinot.$internal.org.apache.pinot.transport.pool.PooledResourceManager;
import org.apache.pinot.common.response.ServerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledNettyClientResourceManager
implements PooledResourceManager<PooledClientConnection> {
    protected static Logger LOGGER = LoggerFactory.getLogger(PooledNettyClientResourceManager.class);
    private KeyedPool<PooledClientConnection> _pool;
    private final EventLoopGroup _eventLoop;
    private final NettyClientMetrics _metrics;
    private final Timer _timer;

    public PooledNettyClientResourceManager(EventLoopGroup eventLoop, Timer timer, NettyClientMetrics metrics) {
        this._eventLoop = eventLoop;
        this._metrics = metrics;
        this._timer = timer;
    }

    public void setPool(KeyedPool<PooledClientConnection> pool) {
        this._pool = pool;
    }

    @Override
    public PooledClientConnection create(ServerInstance key) {
        PooledClientConnection conn = new PooledClientConnection(this._pool, key, this._eventLoop, this._timer, this._metrics);
        conn.connect();
        return conn;
    }

    @Override
    public boolean destroy(ServerInstance key, boolean isBad, PooledClientConnection resource) {
        LOGGER.info("Destroying client connection {}, isBad: {}", (Object)resource, (Object)isBad);
        boolean closed = false;
        try {
            resource.close();
            resource.setDestroyed(true);
            closed = true;
        }
        catch (InterruptedException e) {
            LOGGER.error("Got interrupted exception when closing resource {}", (Object)resource, (Object)e);
        }
        return closed;
    }

    @Override
    public boolean validate(ServerInstance key, PooledClientConnection resource) {
        if (null != resource) {
            return resource.validate();
        }
        return false;
    }

    public class PooledClientConnection
    extends NettyTCPClientConnection
    implements Callback<NoneType> {
        private final KeyedPool<PooledClientConnection> _pool;
        private boolean _destroyed;

        public PooledClientConnection(KeyedPool<PooledClientConnection> pool, ServerInstance server, EventLoopGroup eventGroup, Timer timer, NettyClientMetrics metric) {
            super(server, eventGroup, timer, metric);
            this._destroyed = false;
            this._pool = pool;
            this.init();
        }

        public void setDestroyed(boolean isDestroyed) {
            this._destroyed = isDestroyed;
        }

        public void init() {
            this.setRequestCallback(this);
        }

        @Override
        public void onSuccess(NoneType arg0) {
            this._pool.checkinObject(this.getServer(), this);
        }

        @Override
        public void onError(Throwable arg0) {
            if (this.isSelfClose()) {
                LOGGER.info("Got notified on self-close to {} connId {}", (Object)this._server, (Object)this.getConnId());
            }
            if (!this._destroyed) {
                LOGGER.info("Destroying connection (onError) {} due to error connId {}", new Object[]{this._server, this.getConnId(), arg0.getMessage()});
                this._pool.destroyObject(this.getServer(), this);
                this._destroyed = true;
            }
        }

        @Override
        protected void releaseResources() {
            if (this._pool != null && !this._destroyed) {
                LOGGER.info("Destroying connection (releaseResources) {} due to error connId {}", (Object)this._server, (Object)this.getConnId());
                this._pool.destroyObject(this.getServer(), this);
                this._destroyed = true;
            }
        }
    }
}

