/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.pool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.$internal.com.yammer.metrics.core.Histogram;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricName;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricsRegistry;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.Callback;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.Cancellable;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.LinkedDequeue;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.NoneType;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.AsyncPoolStats;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.PoolStats;
import org.apache.pinot.$internal.org.apache.pinot.transport.pool.AsyncPool;
import org.apache.pinot.$internal.org.apache.pinot.transport.pool.SizeLimitExceededException;
import org.apache.pinot.common.metrics.LatencyMetric;
import org.apache.pinot.common.metrics.MetricsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPoolImpl<T>
implements AsyncPool<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncPoolImpl.class);
    private final String _poolName;
    private final AsyncPool.Lifecycle<T> _lifecycle;
    private final int _maxSize;
    private final int _maxWaiters;
    private final long _idleTimeout;
    private final ScheduledExecutorService _timeoutExecutor;
    private final ExecutorService _callbackExecutor;
    private final int _minSize;
    private volatile ScheduledFuture<?> _objectTimeoutFuture;
    private final Strategy _strategy;
    private final Object _lock = new Object();
    private int _poolSize = 0;
    private final Deque<TimedObject<T>> _idle = new LinkedList<TimedObject<T>>();
    private final LinkedDequeue<Callback<T>> _waiters = new LinkedDequeue();
    private Throwable _lastCreateError = null;
    private State _state = State.NOT_YET_STARTED;
    private Callback<NoneType> _shutdownCallback = null;
    private final Histogram _waitTime;
    private int _totalCreated = 0;
    private int _totalDestroyed = 0;
    private int _totalCreateErrors = 0;
    private int _totalDestroyErrors = 0;
    private int _totalBadDestroyed = 0;
    private int _totalTimedOut = 0;
    private int _sampleMaxCheckedOut = 0;
    private int _sampleMaxPoolSize = 0;
    private int _checkedOut = 0;

    public AsyncPoolImpl(String name, AsyncPool.Lifecycle<T> lifecycle, int maxSize, long idleTimeout, ScheduledExecutorService timeoutExecutor, MetricsRegistry registry) {
        this(name, lifecycle, maxSize, idleTimeout, timeoutExecutor, timeoutExecutor, Integer.MAX_VALUE, registry);
    }

    public AsyncPoolImpl(String name, AsyncPool.Lifecycle<T> lifecycle, int maxSize, long idleTimeout, ScheduledExecutorService timeoutExecutor, ExecutorService callbackExecutor, int maxWaiters, MetricsRegistry registry) {
        this._poolName = name;
        this._lifecycle = lifecycle;
        this._maxSize = maxSize;
        this._idleTimeout = idleTimeout;
        this._timeoutExecutor = timeoutExecutor;
        this._callbackExecutor = callbackExecutor;
        this._maxWaiters = maxWaiters;
        this._strategy = Strategy.MRU;
        this._minSize = 0;
        this._waitTime = MetricsHelper.newHistogram(registry, new MetricName(AsyncPoolImpl.class, name), false);
    }

    public AsyncPoolImpl(String name, AsyncPool.Lifecycle<T> lifecycle, int maxSize, long idleTimeout, ScheduledExecutorService timeoutExecutor, ExecutorService callbackExecutor, int maxWaiters, Strategy strategy, int minSize, MetricsRegistry registry) {
        this._poolName = name;
        this._lifecycle = lifecycle;
        this._maxSize = maxSize;
        this._idleTimeout = idleTimeout;
        this._timeoutExecutor = timeoutExecutor;
        this._callbackExecutor = callbackExecutor;
        this._maxWaiters = maxWaiters;
        this._strategy = strategy;
        this._minSize = minSize;
        this._waitTime = MetricsHelper.newHistogram(registry, new MetricName(AsyncPoolImpl.class, name), false);
    }

    @Override
    public String getName() {
        return this._poolName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this._lock;
        synchronized (object) {
            if (this._state != State.NOT_YET_STARTED) {
                throw new IllegalStateException(this._poolName + " is " + (Object)((Object)this._state));
            }
            this._state = State.RUNNING;
            if (this._idleTimeout > 0L) {
                LOGGER.info("{} Setting up timeout job to run every {} ms", (Object)this._poolName, (Object)this._idleTimeout);
                long freq = Math.min(this._idleTimeout / 10L, 1000L);
                this._objectTimeoutFuture = this._timeoutExecutor.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        AsyncPoolImpl.this.timeoutObjects();
                    }
                }, freq, freq, TimeUnit.MILLISECONDS);
            }
        }
        for (int i = 0; i < this._minSize; ++i) {
            if (!this.shouldCreate()) continue;
            this.create();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(Callback<NoneType> callback) {
        State state;
        this._lifecycle.shutdown();
        Object object = this._lock;
        synchronized (object) {
            state = this._state;
            if (state == State.RUNNING) {
                this._state = State.SHUTTING_DOWN;
                this._shutdownCallback = callback;
            }
        }
        if (state != State.RUNNING) {
            callback.onError(new IllegalStateException(this._poolName + " is " + (Object)((Object)this._state)));
            return;
        }
        LOGGER.info("{}: {}", (Object)this._poolName, (Object)"shutdown requested");
        this.shutdownIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Callback<T>> cancelWaiters() {
        Object object = this._lock;
        synchronized (object) {
            Callback<T> item;
            ArrayList<Callback<T>> cancelled = new ArrayList<Callback<T>>(this._waiters.size());
            while ((item = this._waiters.poll()) != null) {
                cancelled.add(item);
            }
            return cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cancellable get(Callback<T> callback) {
        LinkedDequeue.Node<TimeTrackingCallback<T>> node;
        boolean create = false;
        boolean reject = false;
        TimeTrackingCallback callbackWithTracking = new TimeTrackingCallback(callback);
        while (true) {
            State state;
            TimedObject<T> obj = null;
            Object object = this._lock;
            synchronized (object) {
                state = this._state;
                if (state == State.RUNNING && (obj = this._strategy == Strategy.LRU ? this._idle.pollFirst() : this._idle.pollLast()) == null) {
                    if (this._waiters.size() < this._maxWaiters) {
                        node = this._waiters.addLastNode(callbackWithTracking);
                        create = this.shouldCreate();
                    } else {
                        reject = true;
                        node = null;
                    }
                    break;
                }
            }
            if (state != State.RUNNING) {
                callbackWithTracking.onError(new IllegalStateException(this._poolName + " is " + (Object)((Object)this._state)));
                return null;
            }
            Object rawObj = obj.get();
            if (this._lifecycle.validateGet(rawObj)) {
                this.trc("dequeued an idle object");
                Object object2 = this._lock;
                synchronized (object2) {
                    ++this._checkedOut;
                    this._sampleMaxCheckedOut = Math.max(this._checkedOut, this._sampleMaxCheckedOut);
                }
                callbackWithTracking.onSuccess(rawObj);
                return null;
            }
            this.destroy(rawObj, true);
            this.trc("dequeued and disposed an invalid idle object");
        }
        if (reject) {
            callbackWithTracking.onError(new SizeLimitExceededException("AsyncPool " + this._poolName + " reached maximum waiter size: " + this._maxWaiters));
            return null;
        }
        this.trc("enqueued a waiter");
        if (create) {
            this.create();
        }
        return new Cancellable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancel() {
                Object object = AsyncPoolImpl.this._lock;
                synchronized (object) {
                    return AsyncPoolImpl.this._waiters.removeNode(node) != null;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T obj) {
        Object object = this._lock;
        synchronized (object) {
            --this._checkedOut;
        }
        if (!this._lifecycle.validatePut(obj)) {
            this.destroy(obj, true);
            return;
        }
        this.add(obj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(T obj, boolean isNewlyCreatedObject) {
        Callback<NoneType> shutdown;
        Callback<T> waiter;
        Object object = this._lock;
        synchronized (object) {
            if (isNewlyCreatedObject) {
                ++this._poolSize;
                this._sampleMaxPoolSize = Math.max(this._poolSize, this._sampleMaxPoolSize);
            }
            if ((waiter = this._waiters.poll()) == null) {
                this._idle.offerLast(new TimedObject<T>(obj));
            } else {
                ++this._checkedOut;
                this._sampleMaxCheckedOut = Math.max(this._checkedOut, this._sampleMaxCheckedOut);
            }
            shutdown = this.checkShutdownComplete();
        }
        if (waiter != null) {
            this.trc("dequeued a waiter");
            waiter.onSuccess(obj);
        } else {
            this.trc("enqueued an idle object");
        }
        if (shutdown != null) {
            this.finishShutdown(shutdown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(T obj) {
        Object object = this._lock;
        synchronized (object) {
            --this._checkedOut;
        }
        this.destroy(obj, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PoolStats<Histogram> getStats() {
        Object object = this._lock;
        synchronized (object) {
            PoolStats.LifecycleStats<Histogram> lifecycleStats = this._lifecycle.getStats();
            AsyncPoolStats<Histogram> stats = new AsyncPoolStats<Histogram>(this._totalCreated, this._totalDestroyed, this._totalCreateErrors, this._totalDestroyErrors, this._totalBadDestroyed, this._totalTimedOut, this._checkedOut, this._maxSize, this._minSize, this._poolSize, this._sampleMaxCheckedOut, this._sampleMaxPoolSize, this._idle.size(), new LatencyMetric<Histogram>(this._waitTime), lifecycleStats);
            this._sampleMaxCheckedOut = this._checkedOut;
            this._sampleMaxPoolSize = this._poolSize;
            return stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(T obj, boolean bad) {
        if (bad) {
            Object object = this._lock;
            synchronized (object) {
                ++this._totalBadDestroyed;
            }
        }
        this.trc("disposing a pooled object");
        this._lifecycle.destroy(obj, bad, new Callback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(T t) {
                boolean create;
                Object object = AsyncPoolImpl.this._lock;
                synchronized (object) {
                    AsyncPoolImpl.this._totalDestroyed++;
                    create = AsyncPoolImpl.this.objectDestroyed();
                }
                if (create) {
                    AsyncPoolImpl.this.create();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                boolean create;
                Object object = AsyncPoolImpl.this._lock;
                synchronized (object) {
                    AsyncPoolImpl.this._totalDestroyErrors++;
                    create = AsyncPoolImpl.this.objectDestroyed();
                }
                if (create) {
                    AsyncPoolImpl.this.create();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean objectDestroyed() {
        boolean create;
        Object object = this._lock;
        synchronized (object) {
            if (this._poolSize > 0) {
                --this._poolSize;
            }
            create = this.shouldCreate();
            this.shutdownIfNeeded();
        }
        return create;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldCreate() {
        boolean result = false;
        Object object = this._lock;
        synchronized (object) {
            if (this._state == State.RUNNING) {
                if (this._poolSize >= this._maxSize) {
                    this._lastCreateError = null;
                } else if (this._waiters.size() > 0 || this._poolSize < this._minSize) {
                    result = true;
                }
            }
        }
        LOGGER.debug("PoolSize : {} , Min Size : {}, Max Size : {}, Result : {}, State : {}", new Object[]{this._poolSize, this._minSize, this._maxSize, result, this._state});
        return result;
    }

    private void create() {
        this.trc("initiating object creation");
        this._lifecycle.create(new Callback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(T t) {
                Object object = AsyncPoolImpl.this._lock;
                synchronized (object) {
                    AsyncPoolImpl.this._totalCreated++;
                    AsyncPoolImpl.this._lastCreateError = null;
                }
                AsyncPoolImpl.this.add(t, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(final Throwable e) {
                Collection<Object> waitersDenied;
                boolean create;
                Object object = AsyncPoolImpl.this._lock;
                synchronized (object) {
                    AsyncPoolImpl.this._totalCreateErrors++;
                    AsyncPoolImpl.this._lastCreateError = e;
                    create = AsyncPoolImpl.this.objectDestroyed();
                    if (!AsyncPoolImpl.this._waiters.isEmpty()) {
                        waitersDenied = AsyncPoolImpl.this.cancelWaiters();
                        create = AsyncPoolImpl.this.shouldCreate();
                    } else {
                        waitersDenied = Collections.emptyList();
                    }
                }
                AsyncPoolImpl.this._callbackExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (Callback denied : waitersDenied) {
                            denied.onError(e);
                        }
                    }
                });
                if (create) {
                    AsyncPoolImpl.this.create();
                }
                LOGGER.error(AsyncPoolImpl.this._poolName + ": object creation failed. Create triggered : {}", (Object)create, (Object)e);
            }
        });
    }

    private void timeoutObjects() {
        Collection idle = this.reap(this._idle, this._idleTimeout);
        if (idle.size() > 0) {
            LOGGER.debug("{}: disposing {} objects due to idle timeout", (Object)this._poolName, (Object)idle.size());
            for (Object obj : idle) {
                this.destroy(obj, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <U> Collection<U> reap(Queue<TimedObject<U>> queue, long timeout) {
        ArrayList<U> toReap = new ArrayList<U>();
        long now = System.currentTimeMillis();
        long target = now - timeout;
        Object object = this._lock;
        synchronized (object) {
            TimedObject<U> p;
            for (int excess = this._poolSize - this._minSize; (p = queue.peek()) != null && p.getTime() < target && excess > 0; --excess) {
                toReap.add(queue.poll().get());
                ++this._totalTimedOut;
            }
        }
        return toReap;
    }

    private void shutdownIfNeeded() {
        Callback<NoneType> shutdown = this.checkShutdownComplete();
        if (shutdown != null) {
            this.finishShutdown(shutdown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Callback<NoneType> checkShutdownComplete() {
        int poolSize;
        int idle;
        int waiters;
        State state;
        Callback<NoneType> done = null;
        Object object = this._lock;
        synchronized (object) {
            state = this._state;
            waiters = this._waiters.size();
            idle = this._idle.size();
            poolSize = this._poolSize;
            if (state == State.SHUTTING_DOWN && waiters == 0 && idle == poolSize) {
                this._state = State.STOPPED;
                done = this._shutdownCallback;
                this._shutdownCallback = null;
            }
        }
        if (state == State.SHUTTING_DOWN && done == null) {
            LOGGER.info("{}: {} waiters and {} objects outstanding before shutdown", new Object[]{this._poolName, waiters, poolSize - idle});
        }
        return done;
    }

    private void finishShutdown(Callback<NoneType> shutdown) {
        ScheduledFuture<?> future = this._objectTimeoutFuture;
        if (future != null) {
            future.cancel(false);
        }
        LOGGER.info("{}: {}", (Object)this._poolName, (Object)"Discarding resources before shutdown");
        TimedObject<T> obj = this._idle.pollFirst();
        while (obj != null) {
            this.destroy(obj.get(), false);
            obj = this._idle.pollFirst();
        }
        LOGGER.info("{}: {}", (Object)this._poolName, (Object)"shutdown complete");
        shutdown.onSuccess(NoneType.NONE);
    }

    private void trc(Object toLog) {
        LOGGER.trace("{}: {}", (Object)this._poolName, toLog);
    }

    public String toString() {
        return this.getStats().toString();
    }

    public Throwable getLastCreateError() {
        return this._lastCreateError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate(boolean recreate) {
        if (recreate) {
            throw new UnsupportedOperationException("Recreate=true is not yet supported");
        }
        Object object = this._lock;
        synchronized (object) {
            Iterator<TimedObject<T>> it = this._idle.iterator();
            while (it.hasNext()) {
                TimedObject<T> obj = it.next();
                T rawObj = obj.get();
                if (!this._lifecycle.validate(rawObj)) {
                    it.remove();
                    this.destroy(rawObj, true);
                    LOGGER.info("Destroyed invalid object " + rawObj);
                    continue;
                }
                LOGGER.info("Keeping valid object " + rawObj);
            }
        }
        return true;
    }

    private class TimeTrackingCallback<T2>
    implements Callback<T2> {
        private final long _startTime;
        private final Callback<T2> _callback;

        public TimeTrackingCallback(Callback<T2> callback) {
            this._callback = callback;
            this._startTime = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            Object object = AsyncPoolImpl.this._lock;
            synchronized (object) {
                AsyncPoolImpl.this._waitTime.update(System.currentTimeMillis() - this._startTime);
            }
            this._callback.onError(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(T2 result) {
            Object object = AsyncPoolImpl.this._lock;
            synchronized (object) {
                AsyncPoolImpl.this._waitTime.update(System.currentTimeMillis() - this._startTime);
            }
            this._callback.onSuccess(result);
        }
    }

    private static class TimedObject<T> {
        private final T _obj;
        private final long _time;

        public TimedObject(T obj) {
            this._obj = obj;
            this._time = System.currentTimeMillis();
        }

        public T get() {
            return this._obj;
        }

        public long getTime() {
            return this._time;
        }
    }

    public static enum Strategy {
        MRU,
        LRU;

    }

    private static enum State {
        NOT_YET_STARTED,
        RUNNING,
        SHUTTING_DOWN,
        STOPPED;

    }
}

