/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.pool;

import java.util.concurrent.ExecutorService;
import org.apache.pinot.$internal.com.yammer.metrics.core.Histogram;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricName;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricsRegistry;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.Callback;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.PoolStats;
import org.apache.pinot.$internal.org.apache.pinot.transport.pool.AsyncPool;
import org.apache.pinot.$internal.org.apache.pinot.transport.pool.PooledResourceManager;
import org.apache.pinot.common.metrics.LatencyMetric;
import org.apache.pinot.common.metrics.MetricsHelper;
import org.apache.pinot.common.response.ServerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPoolResourceManagerAdapter<T>
implements AsyncPool.Lifecycle<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncPoolResourceManagerAdapter.class);
    private final PooledResourceManager<T> _resourceManager;
    private final ExecutorService _executor;
    private final ServerInstance _key;
    private final Histogram _histogram;
    private boolean _isShuttingDown = false;

    public AsyncPoolResourceManagerAdapter(ServerInstance key, PooledResourceManager<T> resourceManager, ExecutorService executorService, MetricsRegistry registry) {
        this._resourceManager = resourceManager;
        this._executor = executorService;
        this._key = key;
        this._histogram = MetricsHelper.newHistogram(registry, new MetricName(AsyncPoolResourceManagerAdapter.class, key.toString()), false);
    }

    @Override
    public void shutdown() {
        this._isShuttingDown = true;
    }

    @Override
    public void create(final Callback<T> callback) {
        final long startTime = System.currentTimeMillis();
        this._executor.submit(new Runnable(){

            @Override
            public void run() {
                Object resource = AsyncPoolResourceManagerAdapter.this._resourceManager.create(AsyncPoolResourceManagerAdapter.this._key);
                AsyncPoolResourceManagerAdapter.this._histogram.update(System.currentTimeMillis() - startTime);
                if (null != resource) {
                    callback.onSuccess(resource);
                } else {
                    callback.onError(new Exception("Unable to create resource for key " + AsyncPoolResourceManagerAdapter.this._key));
                }
            }
        });
    }

    @Override
    public boolean validate(T obj) {
        return this._resourceManager.validate(this._key, obj);
    }

    @Override
    public boolean validateGet(T obj) {
        return this._resourceManager.validate(this._key, obj);
    }

    @Override
    public boolean validatePut(T obj) {
        return this._resourceManager.validate(this._key, obj);
    }

    @Override
    public void destroy(final T obj, final boolean error, final Callback<T> callback) {
        try {
            this._executor.submit(new Runnable(){

                @Override
                public void run() {
                    LOGGER.info("Running teardown for the client connection " + obj + " Error is : " + error);
                    boolean success = AsyncPoolResourceManagerAdapter.this._resourceManager.destroy(AsyncPoolResourceManagerAdapter.this._key, error, obj);
                    if (success) {
                        callback.onSuccess(obj);
                    } else {
                        callback.onError(new Exception("Unable to destroy resource for key " + AsyncPoolResourceManagerAdapter.this._key));
                    }
                }
            });
        }
        catch (Exception e) {
            if (this._isShuttingDown) {
                LOGGER.info("Could not destroy resource for key {}: {}", (Object)this._key.toString(), (Object)e.getMessage());
            }
            LOGGER.error("Could not destroy resource for key {}: {}", (Object)this._key.toString(), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public PoolStats.LifecycleStats<Histogram> getStats() {
        return new PoolStats.LifecycleStats<Histogram>(new LatencyMetric<Histogram>(this._histogram));
    }
}

