/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.scattergather;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.io.netty.buffer.ByteBuf;
import org.apache.pinot.$internal.io.netty.buffer.Unpooled;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.CompositeFuture;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.ServerResponseFuture;
import org.apache.pinot.$internal.org.apache.pinot.transport.netty.NettyClientConnection;
import org.apache.pinot.$internal.org.apache.pinot.transport.netty.PooledNettyClientResourceManager;
import org.apache.pinot.$internal.org.apache.pinot.transport.pool.KeyedPool;
import org.apache.pinot.$internal.org.apache.pinot.transport.scattergather.ScatterGather;
import org.apache.pinot.$internal.org.apache.pinot.transport.scattergather.ScatterGatherRequest;
import org.apache.pinot.$internal.org.apache.pinot.transport.scattergather.ScatterGatherStats;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.metrics.BrokerQueryPhase;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.response.ServerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScatterGatherImpl
implements ScatterGather {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScatterGatherImpl.class);
    private final KeyedPool<PooledNettyClientResourceManager.PooledClientConnection> _connPool;
    private final ExecutorService _executorService;

    public ScatterGatherImpl(@Nonnull KeyedPool<PooledNettyClientResourceManager.PooledClientConnection> connPool, @Nonnull ExecutorService executorService) {
        this._connPool = connPool;
        this._executorService = executorService;
    }

    @Override
    @Nonnull
    public CompositeFuture<byte[]> scatterGather(@Nonnull ScatterGatherRequest scatterGatherRequest, @Nonnull ScatterGatherStats scatterGatherStats, @Nullable Boolean isOfflineTable, @Nonnull BrokerMetrics brokerMetrics) throws InterruptedException {
        return this.sendRequest(new ScatterGatherRequestContext(scatterGatherRequest), scatterGatherStats, isOfflineTable, brokerMetrics);
    }

    @Override
    @Nonnull
    public CompositeFuture<byte[]> scatterGather(@Nonnull ScatterGatherRequest scatterGatherRequest, @Nonnull ScatterGatherStats scatterGatherStats, @Nonnull BrokerMetrics brokerMetrics) throws InterruptedException {
        return this.scatterGather(scatterGatherRequest, scatterGatherStats, null, brokerMetrics);
    }

    private CompositeFuture<byte[]> sendRequest(ScatterGatherRequestContext scatterGatherRequestContext, ScatterGatherStats scatterGatherStats, Boolean isOfflineTable, BrokerMetrics brokerMetrics) throws InterruptedException {
        ScatterGatherRequest scatterGatherRequest = scatterGatherRequestContext._request;
        Map<String, List<String>> routingTable = scatterGatherRequest.getRoutingTable();
        CountDownLatch requestDispatchLatch = new CountDownLatch(routingTable.size());
        ArrayList<SingleRequestHandler> handlers = new ArrayList<SingleRequestHandler>(routingTable.size());
        for (Map.Entry<String, List<String>> entry : routingTable.entrySet()) {
            ServerInstance serverInstance = ServerInstance.forInstanceName(entry.getKey());
            String shortServerName = serverInstance.getShortHostName();
            if (isOfflineTable != null) {
                shortServerName = isOfflineTable != false ? shortServerName + "_O" : shortServerName + "_R";
            }
            scatterGatherStats.initServer(shortServerName);
            SingleRequestHandler handler = new SingleRequestHandler(this._connPool, serverInstance, scatterGatherRequest, entry.getValue(), scatterGatherRequestContext.getRemainingTimeMs(), requestDispatchLatch, brokerMetrics);
            this._executorService.submit(handler);
            handlers.add(handler);
        }
        CompositeFuture<byte[]> response = new CompositeFuture<byte[]>("scatterRequest " + scatterGatherRequest.getRequestId(), CompositeFuture.GatherModeOnError.SHORTCIRCUIT_AND);
        long timeRemaining = scatterGatherRequestContext.getRemainingTimeMs();
        boolean sentSuccessfully = requestDispatchLatch.await(timeRemaining, TimeUnit.MILLISECONDS);
        if (sentSuccessfully) {
            ArrayList responseFutures = new ArrayList();
            for (SingleRequestHandler h : handlers) {
                responseFutures.add(h.getResponseFuture());
                String shortServerName = h.getServer().getShortHostName();
                if (isOfflineTable != null) {
                    shortServerName = isOfflineTable != false ? shortServerName + "_O" : shortServerName + "_R";
                }
                scatterGatherStats.setSendStartTimeMillis(shortServerName, h.getConnStartTimeMillis());
                scatterGatherStats.setConnStartTimeMillis(shortServerName, h.getStartDelayMillis());
                scatterGatherStats.setSendCompletionTimeMillis(shortServerName, h.getSendCompletionTimeMillis());
            }
            response.start(responseFutures);
        } else {
            LOGGER.error("Request (" + scatterGatherRequest.getRequestId() + ") not sent completely within time (" + timeRemaining + " ms) !! Cancelling !!. NumSentFailed:" + requestDispatchLatch.getCount());
            response.start(null);
            for (SingleRequestHandler h : handlers) {
                LOGGER.info("Request {} to {} was sent successfully:{}, cancelling.", new Object[]{scatterGatherRequest.getRequestId(), h.getServer(), h.isSent()});
                h.cancel();
            }
        }
        return response;
    }

    private static class ConnectionLimitReachedException
    extends RuntimeException {
        ConnectionLimitReachedException(String msg) {
            super(msg);
        }
    }

    private static class SingleRequestHandler
    implements Runnable {
        private static final int MAX_CONN_RETRIES = 3;
        private final ScatterGatherRequest _request;
        private final List<String> _segments;
        private final ServerInstance _server;
        private final CountDownLatch _requestDispatchLatch;
        private volatile NettyClientConnection.ResponseFuture _responseFuture;
        private final KeyedPool<PooledNettyClientResourceManager.PooledClientConnection> _connPool;
        private final AtomicBoolean _isSent = new AtomicBoolean(false);
        private final AtomicBoolean _isCancelled = new AtomicBoolean(false);
        private final long _timeoutMS;
        private final long _initTime;
        private final BrokerMetrics _brokerMetrics;
        private long _startTime;
        private long _endTime;

        public SingleRequestHandler(KeyedPool<PooledNettyClientResourceManager.PooledClientConnection> connPool, ServerInstance server, ScatterGatherRequest request, List<String> segments, long timeoutMS, CountDownLatch latch, BrokerMetrics brokerMetrics) {
            this._connPool = connPool;
            this._server = server;
            this._request = request;
            this._segments = segments;
            this._requestDispatchLatch = latch;
            this._timeoutMS = timeoutMS;
            this._initTime = System.currentTimeMillis();
            this._brokerMetrics = brokerMetrics;
        }

        @Override
        public synchronized void run() {
            try {
                this._startTime = System.currentTimeMillis();
                this.runInternal();
            }
            finally {
                this._endTime = System.currentTimeMillis();
            }
        }

        public long getConnStartTimeMillis() {
            return this._startTime - this._initTime;
        }

        public long getSendCompletionTimeMillis() {
            return this._endTime > this._initTime ? this._endTime - this._initTime : 0L;
        }

        public long getStartDelayMillis() {
            return this._startTime - this._initTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runInternal() {
            if (this._isCancelled.get()) {
                LOGGER.error("Request {} to server {} cancelled even before request is sent !! Not sending request", (Object)this._request.getRequestId(), (Object)this._server);
                this._requestDispatchLatch.countDown();
                return;
            }
            PooledNettyClientResourceManager.PooledClientConnection conn = null;
            ServerResponseFuture<PooledNettyClientResourceManager.PooledClientConnection> serverResponseFuture = null;
            boolean gotConnection = false;
            boolean error = true;
            long timeRemainingMillis = this._timeoutMS - (System.currentTimeMillis() - this._startTime);
            long startTimeNs = System.nanoTime();
            long timeWaitedNs = 0L;
            try {
                serverResponseFuture = this._connPool.checkoutObject(this._server, String.valueOf(this._request.getRequestId()));
                byte[] serializedRequest = this._request.getRequestForService(this._segments);
                int ntries = 0;
                while (true) {
                    if (timeRemainingMillis <= 0L) {
                        throw new TimeoutException("Timed out trying to connect to " + this._server + "(timeout=" + this._timeoutMS + "ms,ntries=" + ntries + ")");
                    }
                    conn = serverResponseFuture.getOne(timeRemainingMillis, TimeUnit.MILLISECONDS);
                    if (conn != null && conn.validate()) break;
                    Map<ServerInstance, Throwable> errorMap = serverResponseFuture.getError();
                    String errStr = "";
                    if (errorMap != null && errorMap.containsKey(this._server)) {
                        errStr = errorMap.get(this._server).getMessage();
                    }
                    if (conn != null) {
                        LOGGER.warn("Destroying invalid conn {}:{}", (Object)conn, (Object)errStr);
                        this._connPool.destroyObject(this._server, conn);
                    }
                    if (++ntries == 2) {
                        throw new ConnectionLimitReachedException("Could not connect to " + this._server + " after " + ntries + " attempts(timeRemaining=" + timeRemainingMillis + "ms)");
                    }
                    serverResponseFuture = this._connPool.checkoutObject(this._server, "none");
                    timeRemainingMillis = this._timeoutMS - (System.currentTimeMillis() - this._startTime);
                }
                timeWaitedNs = System.nanoTime() - startTimeNs;
                gotConnection = true;
                ByteBuf req = Unpooled.wrappedBuffer(serializedRequest);
                this._responseFuture = conn.sendRequest(req, this._request.getRequestId(), timeRemainingMillis);
                this._isSent.set(true);
                LOGGER.debug("Response Future is : {}", (Object)this._responseFuture);
                error = false;
            }
            catch (TimeoutException e1) {
                LOGGER.warn("Timed out waiting for connection for server ({})({})(gotConnection={}):{}. See metric {}", new Object[]{this._server, this._request.getRequestId(), gotConnection, e1.getMessage(), BrokerMeter.REQUEST_DROPPED_DUE_TO_CONNECTION_ERROR.getMeterName()});
                this._responseFuture = new NettyClientConnection.ResponseFuture(this._server, e1, "Error Future for request " + this._request.getRequestId());
            }
            catch (ConnectionLimitReachedException e) {
                LOGGER.warn("Request {} not sent (gotConnection={}):{}. See metric {}", new Object[]{this._request.getRequestId(), gotConnection, e.getMessage(), BrokerMeter.REQUEST_DROPPED_DUE_TO_CONNECTION_ERROR.getMeterName()});
                this._responseFuture = new NettyClientConnection.ResponseFuture(this._server, e, "Error Future for request " + this._request.getRequestId());
            }
            catch (Exception e) {
                LOGGER.error("Got exception sending request ({})(gotConnection={}). Setting error future", new Object[]{this._request.getRequestId(), gotConnection, e});
                this._responseFuture = new NettyClientConnection.ResponseFuture(this._server, e, "Error Future for request " + this._request.getRequestId());
            }
            finally {
                this._requestDispatchLatch.countDown();
                BrokerRequest brokerRequest = this._request.getBrokerRequest();
                this._brokerMetrics.addPhaseTiming(brokerRequest, BrokerQueryPhase.REQUEST_CONNECTION_WAIT, timeWaitedNs);
                if (timeRemainingMillis < 0L) {
                    this._brokerMetrics.addMeteredQueryValue(brokerRequest, BrokerMeter.REQUEST_CONNECTION_TIMEOUTS, 1L);
                }
                if (error) {
                    if (gotConnection) {
                        this._brokerMetrics.addMeteredQueryValue(brokerRequest, BrokerMeter.REQUEST_DROPPED_DUE_TO_SEND_ERROR, 1L);
                    } else {
                        if (serverResponseFuture != null) {
                            serverResponseFuture.cancel(true);
                        }
                        this._brokerMetrics.addMeteredQueryValue(brokerRequest, BrokerMeter.REQUEST_DROPPED_DUE_TO_CONNECTION_ERROR, 1L);
                    }
                }
            }
        }

        public synchronized void cancel() {
            if (this._isCancelled.get()) {
                return;
            }
            this._isCancelled.set(true);
            if (this._isSent.get()) {
                this._responseFuture.cancel(true);
            }
        }

        public ServerInstance getServer() {
            return this._server;
        }

        public NettyClientConnection.ResponseFuture getResponseFuture() {
            return this._responseFuture;
        }

        public boolean isSent() {
            return this._isSent.get();
        }
    }

    private static class ScatterGatherRequestContext {
        private final ScatterGatherRequest _request;
        private final long _startTimeMs;

        public ScatterGatherRequestContext(ScatterGatherRequest request) {
            this._request = request;
            this._startTimeMs = System.currentTimeMillis();
        }

        public long getRemainingTimeMs() {
            long timeout = this._request.getRequestTimeoutMs();
            if (timeout < 0L) {
                return Long.MAX_VALUE;
            }
            long timeElapsed = System.currentTimeMillis() - this._startTimeMs;
            return timeout - timeElapsed;
        }
    }
}

