/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.scattergather;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pinot.common.response.ServerInstance;

@NotThreadSafe
public class ScatterGatherStats {
    public static final String OFFLINE_TABLE_SUFFIX = "_O";
    public static final String REALTIME_TABLE_SUFFIX = "_R";
    private Map<String, PerServerStats> _perServerStatsMap = new HashMap<String, PerServerStats>();

    public void initServer(String server) {
        this._perServerStatsMap.put(server, new PerServerStats());
    }

    public void setSendStartTimeMillis(String server, long millis) {
        this._perServerStatsMap.get(server).setSendStartTimeMillis(millis);
    }

    public void setConnStartTimeMillis(String server, long millis) {
        this._perServerStatsMap.get(server).setConnStartDelayMillis(millis);
    }

    public void setSendCompletionTimeMillis(String server, long millis) {
        this._perServerStatsMap.get(server).setSendCompletionTimeMillis(millis);
    }

    public void setResponseTimeMillis(Map<ServerInstance, Long> responseTimeMap, boolean isOfflineTable) {
        for (Map.Entry<ServerInstance, Long> entry : responseTimeMap.entrySet()) {
            String shortServerName = entry.getKey().getShortHostName();
            shortServerName = isOfflineTable ? shortServerName + OFFLINE_TABLE_SUFFIX : shortServerName + REALTIME_TABLE_SUFFIX;
            this._perServerStatsMap.get(shortServerName).setResponseTimeMillis(entry.getValue());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFirstEntry = true;
        for (Map.Entry<String, PerServerStats> entry : this._perServerStatsMap.entrySet()) {
            if (isFirstEntry) {
                isFirstEntry = false;
            } else {
                stringBuilder.append(';');
            }
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    private class PerServerStats {
        private long _connStartDelayMillis;
        private long _sendStartTimeMillis;
        private long _sendCompletionTimeMillis;
        private long _responseTimeMillis;

        private PerServerStats() {
        }

        private void setConnStartDelayMillis(long connStartDelayMillis) {
            this._connStartDelayMillis = connStartDelayMillis;
        }

        private void setSendStartTimeMillis(long sendStartTimeMillis) {
            this._sendStartTimeMillis = sendStartTimeMillis;
        }

        private void setSendCompletionTimeMillis(long sendCompletionTimeMillis) {
            this._sendCompletionTimeMillis = sendCompletionTimeMillis;
        }

        private void setResponseTimeMillis(long responseTimeMillis) {
            this._responseTimeMillis = responseTimeMillis;
        }

        public String toString() {
            return String.format("%d,%d,%d,%d", this._connStartDelayMillis, this._sendStartTimeMillis, this._sendCompletionTimeMillis, this._responseTimeMillis);
        }
    }
}

