/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.jboss.netty.channel;

import java.net.SocketAddress;
import org.apache.pinot.$internal.org.jboss.netty.channel.Channel;
import org.apache.pinot.$internal.org.jboss.netty.channel.ChannelFuture;
import org.apache.pinot.$internal.org.jboss.netty.channel.Channels;
import org.apache.pinot.$internal.org.jboss.netty.channel.MessageEvent;
import org.apache.pinot.$internal.org.jboss.netty.util.internal.StringUtil;

public class UpstreamMessageEvent
implements MessageEvent {
    private final Channel channel;
    private final Object message;
    private final SocketAddress remoteAddress;

    public UpstreamMessageEvent(Channel channel, Object message, SocketAddress remoteAddress) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.channel = channel;
        this.message = message;
        this.remoteAddress = remoteAddress != null ? remoteAddress : channel.getRemoteAddress();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ChannelFuture getFuture() {
        return Channels.succeededFuture(this.getChannel());
    }

    public Object getMessage() {
        return this.message;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String toString() {
        if (this.getRemoteAddress() == this.getChannel().getRemoteAddress()) {
            return this.getChannel().toString() + " RECEIVED: " + StringUtil.stripControlCharacters(this.getMessage());
        }
        return this.getChannel().toString() + " RECEIVED: " + StringUtil.stripControlCharacters(this.getMessage()) + " from " + this.getRemoteAddress();
    }
}

