/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.jboss.netty.channel.socket.oio;

import java.io.PushbackInputStream;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.apache.pinot.;
import org.apache.pinot.$internal.org.jboss.netty.channel.ChannelEvent;
import org.apache.pinot.$internal.org.jboss.netty.channel.ChannelFuture;
import org.apache.pinot.$internal.org.jboss.netty.channel.ChannelFutureListener;
import org.apache.pinot.$internal.org.jboss.netty.channel.ChannelPipeline;
import org.apache.pinot.$internal.org.jboss.netty.channel.ChannelState;
import org.apache.pinot.$internal.org.jboss.netty.channel.ChannelStateEvent;
import org.apache.pinot.$internal.org.jboss.netty.channel.Channels;
import org.apache.pinot.$internal.org.jboss.netty.channel.MessageEvent;
import org.apache.pinot.$internal.org.jboss.netty.channel.socket.oio.AbstractOioChannelSink;
import org.apache.pinot.$internal.org.jboss.netty.channel.socket.oio.AbstractOioWorker;
import org.apache.pinot.$internal.org.jboss.netty.channel.socket.oio.OioClientSocketChannel;
import org.apache.pinot.$internal.org.jboss.netty.channel.socket.oio.OioWorker;
import org.apache.pinot.$internal.org.jboss.netty.util.ThreadRenamingRunnable;
import org.apache.pinot.$internal.org.jboss.netty.util.internal.DeadLockProofWorker;

class OioClientSocketPipelineSink
extends AbstractOioChannelSink {
    private final Executor workerExecutor;
    private final .ThreadNameDeterminer determiner;

    OioClientSocketPipelineSink(Executor workerExecutor, .ThreadNameDeterminer determiner) {
        this.workerExecutor = workerExecutor;
        this.determiner = determiner;
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        OioClientSocketChannel channel = (OioClientSocketChannel)e.getChannel();
        ChannelFuture future = e.getFuture();
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent stateEvent = (ChannelStateEvent)e;
            ChannelState state = stateEvent.getState();
            Object value = stateEvent.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    AbstractOioWorker.close(channel, future);
                    break;
                }
                case BOUND: {
                    if (value != null) {
                        OioClientSocketPipelineSink.bind(channel, future, (SocketAddress)value);
                        break;
                    }
                    AbstractOioWorker.close(channel, future);
                    break;
                }
                case CONNECTED: {
                    if (value != null) {
                        this.connect(channel, future, (SocketAddress)value);
                        break;
                    }
                    AbstractOioWorker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    AbstractOioWorker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            OioWorker.write(channel, future, ((MessageEvent)e).getMessage());
        }
    }

    private static void bind(OioClientSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        try {
            channel.socket.bind(localAddress);
            future.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connect(OioClientSocketChannel channel, ChannelFuture future, SocketAddress remoteAddress) {
        boolean bound = channel.isBound();
        boolean connected = false;
        boolean workerStarted = false;
        future.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        try {
            try {
                channel.socket.connect(remoteAddress, channel.getConfig().getConnectTimeoutMillis());
                connected = true;
                channel.in = new PushbackInputStream(channel.socket.getInputStream(), 1);
                channel.out = channel.socket.getOutputStream();
                future.setSuccess();
                if (!bound) {
                    Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
                }
                Channels.fireChannelConnected(channel, (SocketAddress)channel.getRemoteAddress());
                DeadLockProofWorker.start(this.workerExecutor, new ThreadRenamingRunnable(new OioWorker(channel), "Old I/O client worker (" + channel + ')', this.determiner));
                workerStarted = true;
            }
            catch (Throwable t22) {
                ConnectException t22;
                if (t22 instanceof ConnectException && t22 instanceof ConnectException) {
                    ConnectException newT = new ConnectException(t22.getMessage() + ": " + remoteAddress);
                    newT.setStackTrace(t22.getStackTrace());
                    t22 = newT;
                }
                future.setFailure(t22);
                Channels.fireExceptionCaught(channel, (Throwable)t22);
                Object var10_8 = null;
                if (!connected) return;
                if (workerStarted) return;
                AbstractOioWorker.close(channel, future);
                return;
            }
            Object var10_7 = null;
            if (!connected) return;
            if (workerStarted) return;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (!connected) throw throwable;
            if (workerStarted) throw throwable;
            AbstractOioWorker.close(channel, future);
            throw throwable;
        }
        AbstractOioWorker.close(channel, future);
    }
}

