/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.jboss.netty.handler.codec.http.multipart;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.$internal.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.pinot.$internal.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.pinot.$internal.org.jboss.netty.handler.codec.http.multipart.Attribute;
import org.apache.pinot.$internal.org.jboss.netty.handler.codec.http.multipart.InterfaceHttpData;

public class InternalAttribute
implements InterfaceHttpData {
    protected final List<String> value = new ArrayList<String>();
    private final Charset charset;

    public InternalAttribute(Charset charset) {
        this.charset = charset;
    }

    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return InterfaceHttpData.HttpDataType.InternalAttribute;
    }

    public void addValue(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.value.add(value);
    }

    public void addValue(String value, int rank) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.value.add(rank, value);
    }

    public void setValue(String value, int rank) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.value.set(rank, value);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return this.getName().equalsIgnoreCase(attribute.getName());
    }

    public int compareTo(InterfaceHttpData o) {
        if (!(o instanceof InternalAttribute)) {
            throw new ClassCastException("Cannot compare " + (Object)((Object)this.getHttpDataType()) + " with " + (Object)((Object)o.getHttpDataType()));
        }
        return this.compareTo((InternalAttribute)o);
    }

    public int compareTo(InternalAttribute o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public int size() {
        int size = 0;
        for (String elt : this.value) {
            try {
                size += elt.getBytes(this.charset.name()).length;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return size;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (String elt : this.value) {
            result.append(elt);
        }
        return result.toString();
    }

    public ChannelBuffer toChannelBuffer() {
        ChannelBuffer[] buffers = new ChannelBuffer[this.value.size()];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = ChannelBuffers.copiedBuffer(this.value.get(i), this.charset);
        }
        return ChannelBuffers.wrappedBuffer(buffers);
    }

    public String getName() {
        return "InternalAttribute";
    }
}

