/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.jboss.netty.handler.execution;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.;
import org.apache.pinot.$internal.org.jboss.netty.channel.ChannelEvent;
import org.apache.pinot.$internal.org.jboss.netty.channel.ChannelFuture;
import org.apache.pinot.$internal.org.jboss.netty.channel.ChannelFutureListener;
import org.apache.pinot.$internal.org.jboss.netty.handler.execution.ChannelEventRunnable;
import org.apache.pinot.$internal.org.jboss.netty.handler.execution.ChannelUpstreamEventRunnable;
import org.apache.pinot.$internal.org.jboss.netty.handler.execution.FairOrderedMemoryAwareThreadPoolExecutor;

public final class FairOrderedDownstreamThreadPoolExecutor
extends FairOrderedMemoryAwareThreadPoolExecutor {
    public FairOrderedDownstreamThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize, 0L, 0L);
    }

    public FairOrderedDownstreamThreadPoolExecutor(int corePoolSize, long keepAliveTime, TimeUnit unit) {
        super(corePoolSize, 0L, 0L, keepAliveTime, unit);
    }

    public FairOrderedDownstreamThreadPoolExecutor(int corePoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        super(corePoolSize, 0L, 0L, keepAliveTime, unit, threadFactory);
    }

    public .ObjectSizeEstimator getObjectSizeEstimator() {
        return null;
    }

    public void setObjectSizeEstimator(.ObjectSizeEstimator objectSizeEstimator) {
        throw new UnsupportedOperationException("Not supported by this implementation");
    }

    public long getMaxChannelMemorySize() {
        return 0L;
    }

    public void setMaxChannelMemorySize(long maxChannelMemorySize) {
        throw new UnsupportedOperationException("Not supported by this implementation");
    }

    public long getMaxTotalMemorySize() {
        return 0L;
    }

    protected boolean shouldCount(Runnable task) {
        return false;
    }

    public void execute(Runnable command) {
        if (command instanceof ChannelUpstreamEventRunnable) {
            throw new RejectedExecutionException("command must be enclosed with an downstream event.");
        }
        this.doExecute(command);
    }

    protected void doExecute(Runnable task) {
        if (task instanceof ChannelEventRunnable) {
            ChannelEventRunnable eventRunnable = (ChannelEventRunnable)task;
            ChannelEvent event = eventRunnable.getEvent();
            FairOrderedMemoryAwareThreadPoolExecutor.EventTask newEventTask = new FairOrderedMemoryAwareThreadPoolExecutor.EventTask(this, eventRunnable);
            final Object key = this.getKey(event);
            FairOrderedMemoryAwareThreadPoolExecutor.EventTask previousEventTask = this.map.put(key, newEventTask);
            if (previousEventTask != null) {
                if (this.compareAndSetNext(previousEventTask, null, newEventTask)) {
                    return;
                }
            } else {
                event.getChannel().getCloseFuture().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        FairOrderedDownstreamThreadPoolExecutor.this.removeKey(key);
                    }
                });
            }
            this.doUnorderedExecute(newEventTask);
        } else {
            this.doUnorderedExecute(task);
        }
    }
}

