/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import io.vavr.Tuple2;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.function.Predicate;
import org.apache.pinot.common.config.ChildKeyTransformer;
import org.apache.pinot.common.config.TableNameBuilder;
import org.apache.pinot.common.utils.CommonConstants;

public class AdjustTableNameChildKeyTransformer
implements ChildKeyTransformer {
    @Override
    public Map<String, ?> apply(Map<String, ?> childKeys, String pathPrefix) {
        List tableTypes = ((List)childKeys.get((Object)"table.types").map(tableTypesListOrString -> {
            if (tableTypesListOrString instanceof String) {
                return List.of((Object)((String)tableTypesListOrString));
            }
            if (tableTypesListOrString instanceof Collection) {
                return List.ofAll((Iterable)((Collection)tableTypesListOrString));
            }
            return List.empty();
        }).getOrElse((Object)List.empty())).map(Object::toString);
        String tableName = (String)childKeys.get((Object)"table.name").map(Object::toString).getOrElse(() -> (String)childKeys.get((Object)"table.name.realtime").map(Object::toString).getOrElse(() -> (String)childKeys.get((Object)"table.name.offline").map(Object::toString).getOrNull()));
        Map remappedConfig = childKeys;
        for (String tableType : tableTypes) {
            String tableNameKey = "table.name." + tableType.toLowerCase();
            CommonConstants.Helix.TableType type = CommonConstants.Helix.TableType.valueOf(tableType.toUpperCase());
            remappedConfig = remappedConfig.put((Object)tableNameKey, (Object)TableNameBuilder.forType(type).tableNameWithType(tableName));
        }
        remappedConfig = remappedConfig.remove((Object)"table.name");
        return remappedConfig;
    }

    @Override
    public Map<String, ?> unapply(Map<String, ?> childKeys, String pathPrefix) {
        String tableNameWithSuffix = ((Tuple2)childKeys.filterKeys((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$unapply$49(java.lang.String ), (Ljava/lang/String;)Z)()).head())._2.toString();
        return childKeys.filterKeys(key -> !key.startsWith("table.name")).put((Object)"table.name", (Object)TableNameBuilder.extractRawTableName(tableNameWithSuffix));
    }

    private static /* synthetic */ boolean lambda$unapply$49(String key) {
        return key.startsWith("table.name");
    }
}

