/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import io.vavr.Tuple;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import org.apache.pinot.common.config.ChildKeyTransformer;
import org.apache.pinot.common.utils.EqualityUtils;

public class CombinedConfigSeparatorChildKeyTransformer
implements ChildKeyTransformer {
    @Override
    public Map<String, ?> apply(Map<String, ?> config, String keyPrefix) {
        Option tableName = config.get((Object)"table.name").map(Object::toString);
        if (tableName.isDefined() && config.getOrElse((Object)"table.schemaName", null) == null) {
            config = config.put((Object)"table.schemaName", tableName.get());
        }
        boolean hasRealtime = config.containsKey((Object)"table.type.realtime");
        boolean hasOffline = config.containsKey((Object)"table.type.offline");
        Map remappedConfig = config.flatMap((k, v) -> {
            if (k.startsWith("table.schema.")) {
                if (k.endsWith(".realtime")) {
                    k = k.substring(0, k.length() - ".realtime".length());
                }
                if (k.endsWith(".offline")) {
                    k = k.substring(0, k.length() - ".offline".length());
                }
                return List.of((Object)Tuple.of((Object)k.replaceFirst("table.schema", "schema"), (Object)v));
            }
            if (k.endsWith(".realtime") && hasRealtime) {
                return List.of((Object)Tuple.of((Object)("realtime." + k.substring(0, k.length() - ".realtime".length())), (Object)v));
            }
            if (k.endsWith(".offline") && hasOffline) {
                return List.of((Object)Tuple.of((Object)("offline." + k.substring(0, k.length() - ".offline".length())), (Object)v));
            }
            List returnValue = List.empty();
            if (hasOffline) {
                returnValue = returnValue.append((Object)Tuple.of((Object)("offline." + k), (Object)v));
            }
            if (hasRealtime) {
                returnValue = returnValue.append((Object)Tuple.of((Object)("realtime." + k), (Object)v));
            }
            return returnValue;
        });
        return remappedConfig;
    }

    @Override
    public Map<String, ?> unapply(Map<String, ?> config, String keyPrefix) {
        Map remappedConfig = config.mapKeys(key -> {
            if (key.startsWith("schema.")) {
                return key.replaceFirst("schema.", "table.schema.");
            }
            if (key.startsWith("realtime.")) {
                return key.replaceFirst("realtime.", "") + ".realtime";
            }
            if (key.startsWith("offline.")) {
                return key.replaceFirst("offline.", "") + ".offline";
            }
            throw new RuntimeException("Unexpected key " + key);
        });
        Set realtimeKeySet = remappedConfig.keySet().filter(key -> key.startsWith("table.") && key.endsWith(".realtime")).map(key -> key.substring(0, key.lastIndexOf(".realtime")));
        Set offlineKeySet = remappedConfig.keySet().filter(key -> key.startsWith("table.") && key.endsWith(".offline")).map(key -> key.substring(0, key.lastIndexOf(".offline")));
        Set commonOfflineAndRealtimeKeys = realtimeKeySet.intersect(offlineKeySet);
        for (String commonOfflineAndRealtimeKey : commonOfflineAndRealtimeKeys) {
            String realtimeKey = commonOfflineAndRealtimeKey + ".realtime";
            String offlineKey = commonOfflineAndRealtimeKey + ".offline";
            Object realtimeValue = remappedConfig.getOrElse((Object)realtimeKey, null);
            Object offlineValue = remappedConfig.getOrElse((Object)offlineKey, null);
            if (!EqualityUtils.isEqual(offlineValue, realtimeValue)) continue;
            remappedConfig = remappedConfig.remove((Object)realtimeKey).remove((Object)offlineKey).put((Object)commonOfflineAndRealtimeKey, offlineValue);
        }
        return remappedConfig;
    }
}

