/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigIncludeContext;
import com.typesafe.config.ConfigIncluder;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigValue;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.pinot.common.Utils;
import org.apache.pinot.common.config.ChildKeyHandler;
import org.apache.pinot.common.config.ChildKeyTransformer;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.config.ConfigNodeLifecycleAware;
import org.apache.pinot.common.config.NestedConfig;
import org.apache.pinot.common.config.Serializer;
import org.apache.pinot.common.config.SingleKeyDsl;
import org.apache.pinot.common.config.UseChildKeyHandler;
import org.apache.pinot.common.config.UseChildKeyTransformers;
import org.apache.pinot.common.config.UseDsl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deserializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Deserializer.class);
    private static final Map<Tuple2<Class, Class>, Function<Object, Object>> typeConverters = new HashMap<Tuple2<Class, Class>, Function<Object, Object>>();
    private static final Set<Class> simpleTypes;

    public static <T> T deserialize(Class<T> clazz, io.vavr.collection.Map<String, ?> config, String configPath) throws Exception {
        ConfigKey rootConfigKey;
        LOGGER.debug("Deserializing object of class {} at config path {} using config {}", new Object[]{clazz.getName(), configPath, config});
        if (config == null) {
            LOGGER.debug("Config is null, returning null value");
            return null;
        }
        T rootObject = clazz.newInstance();
        UseChildKeyTransformers useChildKeyTransformers = clazz.getAnnotation(UseChildKeyTransformers.class);
        if (useChildKeyTransformers != null) {
            for (Class<? extends ChildKeyTransformer> childKeyTransformerClass : useChildKeyTransformers.value()) {
                LOGGER.debug("Using child key transformer {} on the root config {}", childKeyTransformerClass, config);
                ChildKeyTransformer childKeyTransformer = childKeyTransformerClass.newInstance();
                config = childKeyTransformer.apply(config, configPath);
                LOGGER.debug("Config after child key transformation {}", config);
            }
        }
        if ((rootConfigKey = clazz.getAnnotation(ConfigKey.class)) != null) {
            String suffix = rootConfigKey.value() + ".";
            config = Deserializer.subset(suffix, config);
            configPath = configPath + suffix;
            LOGGER.debug("Using subset config {} and config path {}", config, (Object)configPath);
        }
        if (ConfigNodeLifecycleAware.class.isAssignableFrom(clazz)) {
            ((ConfigNodeLifecycleAware)rootObject).preInject();
        }
        io.vavr.collection.List<Field> declaredFields = Deserializer.getClassFields(clazz);
        boolean valueInjected = false;
        for (Field declaredField : declaredFields) {
            try {
                LOGGER.debug("Processing field {}", (Object)declaredField.getName());
                ConfigKey fieldConfigKey = declaredField.getAnnotation(ConfigKey.class);
                boolean isKeylessConfigField = declaredField.getAnnotation(NestedConfig.class) != null;
                UseChildKeyHandler useChildKeyHandler = declaredField.getAnnotation(UseChildKeyHandler.class);
                if (fieldConfigKey != null) {
                    UseDsl dslInfo = declaredField.getAnnotation(UseDsl.class);
                    String keyName = fieldConfigKey.value();
                    if (dslInfo != null) {
                        LOGGER.debug("Using DSL {} to extract value {}", dslInfo.dsl(), (Object)dslInfo.value());
                        SingleKeyDsl dsl = dslInfo.dsl().newInstance();
                        if (!config.containsKey((Object)keyName)) continue;
                        Object dslValue = dsl.parse(config.getOrElse((Object)keyName, null).toString());
                        io.vavr.collection.Map<String, ?> dslValues = Serializer.serialize(dslValue);
                        LOGGER.debug("Extracting value from field {} of {}, values are {}", new Object[]{dslInfo.value(), dslValue, dslValues});
                        if (dslValues == null) continue;
                        valueInjected |= Deserializer.coerceValueIntoField(rootObject, declaredField, dslValues.getOrElse((Object)dslInfo.value(), null));
                        continue;
                    }
                    if (useChildKeyHandler != null) {
                        LOGGER.debug("Using child key handler {}", useChildKeyHandler.value());
                        ChildKeyHandler childKeyHandler = useChildKeyHandler.value().newInstance();
                        Object value = childKeyHandler.handleChildKeys(Deserializer.subset(keyName + ".", config), configPath + "." + keyName);
                        LOGGER.debug("Child key handler returned value {}", value);
                        valueInjected |= Deserializer.coerceValueIntoField(rootObject, declaredField, value);
                        continue;
                    }
                    if (Deserializer.isSimpleType(declaredField.getType())) {
                        LOGGER.debug("Coercing simple value type into field");
                        valueInjected |= Deserializer.coerceValueIntoField(rootObject, declaredField, config.getOrElse((Object)keyName, null));
                        continue;
                    }
                    String suffix = keyName + ".";
                    String newPath = configPath + suffix;
                    LOGGER.debug("Recursively deserializing complex type");
                    valueInjected |= Deserializer.coerceValueIntoField(rootObject, declaredField, Deserializer.deserialize(declaredField.getType(), Deserializer.subset(suffix, config), newPath));
                    continue;
                }
                if (!isKeylessConfigField) continue;
                if (useChildKeyHandler != null) {
                    ChildKeyHandler childKeyHandler = useChildKeyHandler.value().newInstance();
                    Object value = childKeyHandler.handleChildKeys(config, configPath);
                    valueInjected |= Deserializer.coerceValueIntoField(rootObject, declaredField, value);
                    continue;
                }
                valueInjected |= Deserializer.coerceValueIntoField(rootObject, declaredField, Deserializer.deserialize(declaredField.getType(), config, configPath));
            }
            catch (Exception e) {
                LOGGER.warn("Caught exception while serializing field", (Throwable)e);
            }
        }
        if (valueInjected) {
            if (ConfigNodeLifecycleAware.class.isAssignableFrom(clazz)) {
                ((ConfigNodeLifecycleAware)rootObject).postInject();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Returning deserialized value of {}", rootObject);
            }
            return rootObject;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No fields were written to the object of type {}, returning null", (Object)clazz.getName());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> boolean coerceValueIntoField(T parentObject, Field field, Object value) throws ReflectiveOperationException {
        try {
            Object destinationValue;
            Class<?> fieldType;
            if (value == null) {
                return false;
            }
            Class<?> objectType = value.getClass();
            if (objectType.equals(fieldType = field.getType()) || fieldType.isAssignableFrom(objectType)) {
                destinationValue = value;
            } else if (fieldType.equals(String.class)) {
                destinationValue = value.toString();
            } else if (fieldType.isArray()) {
                destinationValue = value;
            } else if (typeConverters.containsKey(Tuple.of(objectType, fieldType))) {
                Function<Object, Object> converter = typeConverters.get(Tuple.of(objectType, fieldType));
                destinationValue = converter.apply(value);
            } else if (value instanceof Number) {
                if (fieldType.isAssignableFrom(objectType)) {
                    destinationValue = value;
                } else {
                    if (!Number.class.isAssignableFrom(fieldType)) {
                        if (!fieldType.isPrimitive()) throw new RuntimeException("Unsupported conversion from " + objectType + " -> " + fieldType);
                    }
                    Number numberValue = (Number)value;
                    if (!Integer.class.isAssignableFrom(fieldType)) {
                        if (!Integer.TYPE.isAssignableFrom(fieldType)) throw new RuntimeException("Unsupported conversion from " + objectType + " -> " + fieldType);
                    }
                    destinationValue = numberValue.intValue();
                }
            } else if (value instanceof String) {
                String stringValue = (String)value;
                try {
                    if (Integer.class.isAssignableFrom(fieldType) || Integer.TYPE.isAssignableFrom(fieldType)) {
                        destinationValue = Integer.parseInt(stringValue);
                    }
                    if (Long.class.isAssignableFrom(fieldType)) {
                        destinationValue = Long.parseLong(stringValue);
                    }
                    if (Boolean.class.isAssignableFrom(fieldType) || Boolean.TYPE.isAssignableFrom(fieldType)) {
                        destinationValue = Boolean.parseBoolean(stringValue);
                    }
                    if (!Enum.class.isAssignableFrom(fieldType)) throw new RuntimeException("Unsupported conversion from " + objectType + " -> " + fieldType);
                    destinationValue = Enum.valueOf(fieldType.asSubclass(Enum.class), stringValue.toUpperCase());
                }
                catch (Exception e) {
                    return false;
                }
            } else {
                if (!(value instanceof Boolean)) throw new RuntimeException("Unsupported conversion from " + objectType + " -> " + fieldType);
                destinationValue = value;
            }
            if (destinationValue == null) return false;
            field.setAccessible(true);
            field.set(parentObject, destinationValue);
            return true;
        }
        catch (Exception e) {
            throw new ReflectiveOperationException("Caught exception while processing field " + field.getName() + " of class " + field.getDeclaringClass(), e);
        }
    }

    public static <T> T deserializeFromString(Class<T> clazz, String string) {
        Config config = ConfigFactory.parseString((String)string, (ConfigParseOptions)ConfigParseOptions.defaults().prependIncluder(new ConfigIncluder(){
            private ConfigIncluder parent = null;

            public ConfigObject include(ConfigIncludeContext context, String what) {
                return ConfigFactory.parseFileAnySyntax((File)new File(what)).root();
            }

            public ConfigIncluder withFallback(ConfigIncluder fallback) {
                this.parent = fallback;
                return this;
            }
        }));
        config = config.resolve();
        try {
            return Deserializer.deserialize(clazz, io.vavr.collection.HashSet.ofAll((Iterable)config.entrySet()).toMap(entry -> Tuple.of(entry.getKey(), (Object)((ConfigValue)entry.getValue()).unwrapped())), "");
        }
        catch (Exception e) {
            Utils.rethrowException(e);
            return null;
        }
    }

    private static io.vavr.collection.List<Field> getClassFields(Class<?> clazz) {
        io.vavr.collection.List fields = io.vavr.collection.List.of((Object[])clazz.getDeclaredFields());
        while (clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            fields = fields.appendAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        return fields;
    }

    private static io.vavr.collection.Map<String, ?> subset(String prefix, io.vavr.collection.Map<String, ?> config) {
        int prefixLength = prefix.length();
        return config.filter((key, value) -> key.startsWith(prefix)).map((key, value) -> Tuple.of((Object)key.substring(prefixLength), (Object)value));
    }

    public static boolean isSimpleType(Class<?> fieldType) {
        return simpleTypes.contains(fieldType) || fieldType.equals(Boolean.TYPE) || fieldType.equals(String.class) || fieldType.equals(TimeUnit.class) || fieldType.isArray() || Enum.class.isAssignableFrom(fieldType);
    }

    static {
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(String.class, Byte.TYPE), str -> {
            try {
                return Byte.parseByte((String)str);
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(String.class, Character.TYPE), str -> {
            String s = (String)str;
            if (s.length() >= 1) {
                return Character.valueOf(s.charAt(0));
            }
            return null;
        });
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(String.class, Short.TYPE), str -> {
            try {
                return Short.parseShort((String)str);
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(String.class, Integer.TYPE), str -> {
            try {
                return Integer.parseInt((String)str);
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(String.class, Long.TYPE), str -> {
            try {
                return Long.parseLong((String)str);
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(String.class, Float.TYPE), str -> {
            try {
                return Float.valueOf(Float.parseFloat((String)str));
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(String.class, Double.TYPE), str -> {
            try {
                return Double.parseDouble((String)str);
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(Number.class, Byte.TYPE), num -> {
            Number n = (Number)num;
            return n.byteValue();
        });
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(Number.class, Character.TYPE), num -> Character.valueOf(num.toString().charAt(0)));
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(Number.class, Short.TYPE), num -> {
            Number n = (Number)num;
            return n.byteValue();
        });
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(Number.class, Integer.TYPE), num -> {
            Number n = (Number)num;
            return n.byteValue();
        });
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(Number.class, Long.TYPE), num -> {
            Number n = (Number)num;
            return n.byteValue();
        });
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(Number.class, Float.TYPE), num -> {
            Number n = (Number)num;
            return n.byteValue();
        });
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(Number.class, Double.TYPE), num -> {
            Number n = (Number)num;
            return n.byteValue();
        });
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(String[].class, Set.class), items -> {
            HashSet<String> set = new HashSet<String>();
            String[] itemArray = (String[])items;
            set.addAll(Arrays.asList(itemArray));
            return set;
        });
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(String[].class, List.class), items -> {
            ArrayList<String> list = new ArrayList<String>();
            String[] itemArray = (String[])items;
            list.addAll(Arrays.asList(itemArray));
            return list;
        });
        typeConverters.put((Tuple2<Class, Class>)Tuple.of(ArrayList.class, Set.class), items -> {
            ArrayList list = (ArrayList)items;
            return new HashSet(list);
        });
        simpleTypes = new HashSet<Class>();
        typeConverters.keySet().forEach(t2 -> simpleTypes.add((Class)t2._2));
    }
}

