/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.config.Duration;
import org.apache.pinot.common.config.SingleKeyDsl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurationDsl
implements SingleKeyDsl<Duration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DurationDsl.class);

    @Override
    public Duration parse(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try {
            String[] parts = text.split(" ");
            String unit = parts[1].toUpperCase();
            String unitCount = parts[0];
            return new Duration(TimeUnit.valueOf(unit), Integer.parseInt(unitCount));
        }
        catch (Exception e) {
            LOGGER.warn("Caught exception while parsing duration {}, discarding the invalid duration.", (Object)e, (Object)text);
            return null;
        }
    }

    @Override
    public String unparse(Duration value) {
        if (value != null) {
            return value.getUnitCount() + " " + (Object)((Object)value.getUnit());
        }
        return null;
    }
}

