/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.config.SegmentPartitionConfig;
import org.apache.pinot.common.config.SimpleMapChildKeyHandler;
import org.apache.pinot.common.config.StarTreeIndexConfig;
import org.apache.pinot.common.config.StreamConsumptionConfig;
import org.apache.pinot.common.config.UseChildKeyHandler;
import org.apache.pinot.common.data.StarTreeIndexSpec;
import org.apache.pinot.common.utils.EqualityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IndexingConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingConfig.class);
    @ConfigKey(value="invertedIndexColumns")
    private List<String> _invertedIndexColumns;
    @ConfigKey(value="autoGeneratedInvertedIndex")
    private boolean _autoGeneratedInvertedIndex;
    @ConfigKey(value="createInvertedIndexDuringSegmentGeneration")
    private boolean _createInvertedIndexDuringSegmentGeneration;
    @ConfigKey(value="sortedColumn")
    private List<String> _sortedColumn = new ArrayList<String>();
    @ConfigKey(value="bloomFilterColumns")
    private List<String> _bloomFilterColumns = new ArrayList<String>();
    @ConfigKey(value="loadMode")
    private String _loadMode;
    @ConfigKey(value="streamConfigs")
    @UseChildKeyHandler(value=SimpleMapChildKeyHandler.class)
    private Map<String, String> _streamConfigs = new HashMap<String, String>();
    @ConfigKey(value="streamConsumptionConfig")
    private StreamConsumptionConfig _streamConsumptionConfig;
    @ConfigKey(value="segmentFormatVersion")
    private String _segmentFormatVersion;
    @ConfigKey(value="columnMinMaxValueGeneratorMode")
    private String _columnMinMaxValueGeneratorMode;
    @ConfigKey(value="noDictionaryColumns")
    private List<String> _noDictionaryColumns;
    @ConfigKey(value="noDictionaryConfig")
    @UseChildKeyHandler(value=SimpleMapChildKeyHandler.class)
    private Map<String, String> _noDictionaryConfig;
    @ConfigKey(value="onHeapDictionaryColumns")
    private List<String> _onHeapDictionaryColumns;
    @ConfigKey(value="starTreeIndexSpec")
    private StarTreeIndexSpec _starTreeIndexSpec;
    @ConfigKey(value="starTreeIndexConfigs")
    private List<StarTreeIndexConfig> _starTreeIndexConfigs;
    @ConfigKey(value="segmentPartitionConfig")
    private SegmentPartitionConfig _segmentPartitionConfig;
    @ConfigKey(value="aggregateMetrics")
    private boolean _aggregateMetrics;

    public List<String> getInvertedIndexColumns() {
        return this._invertedIndexColumns;
    }

    public void setInvertedIndexColumns(List<String> invertedIndexColumns) {
        this._invertedIndexColumns = invertedIndexColumns;
    }

    public boolean isAutoGeneratedInvertedIndex() {
        return this._autoGeneratedInvertedIndex;
    }

    public void setAutoGeneratedInvertedIndex(boolean autoGeneratedInvertedIndex) {
        this._autoGeneratedInvertedIndex = autoGeneratedInvertedIndex;
    }

    public boolean isCreateInvertedIndexDuringSegmentGeneration() {
        return this._createInvertedIndexDuringSegmentGeneration;
    }

    public void setCreateInvertedIndexDuringSegmentGeneration(boolean createInvertedIndexDuringSegmentGeneration) {
        this._createInvertedIndexDuringSegmentGeneration = createInvertedIndexDuringSegmentGeneration;
    }

    public List<String> getSortedColumn() {
        return this._sortedColumn;
    }

    public void setSortedColumn(List<String> sortedColumn) {
        this._sortedColumn = sortedColumn;
    }

    public List<String> getBloomFilterColumns() {
        return this._bloomFilterColumns;
    }

    public void setBloomFilterColumns(List<String> _bloomFilterColumns) {
        this._bloomFilterColumns = _bloomFilterColumns;
    }

    public String getLoadMode() {
        return this._loadMode;
    }

    public void setLoadMode(String loadMode) {
        this._loadMode = loadMode;
    }

    public Map<String, String> getStreamConfigs() {
        return this._streamConfigs;
    }

    public void setStreamConfigs(Map<String, String> streamConfigs) {
        this._streamConfigs = streamConfigs;
    }

    public StreamConsumptionConfig getStreamConsumptionConfig() {
        return this._streamConsumptionConfig;
    }

    public void setStreamConsumptionConfig(StreamConsumptionConfig streamConsumptionConfig) {
        this._streamConsumptionConfig = streamConsumptionConfig;
    }

    public String getSegmentFormatVersion() {
        return this._segmentFormatVersion;
    }

    public void setSegmentFormatVersion(String segmentFormatVersion) {
        this._segmentFormatVersion = segmentFormatVersion;
    }

    public String getColumnMinMaxValueGeneratorMode() {
        return this._columnMinMaxValueGeneratorMode;
    }

    public void setColumnMinMaxValueGeneratorMode(String columnMinMaxValueGeneratorMode) {
        this._columnMinMaxValueGeneratorMode = columnMinMaxValueGeneratorMode;
    }

    public List<String> getNoDictionaryColumns() {
        return this._noDictionaryColumns;
    }

    public Map<String, String> getNoDictionaryConfig() {
        return this._noDictionaryConfig;
    }

    public List<String> getOnHeapDictionaryColumns() {
        return this._onHeapDictionaryColumns;
    }

    public void setNoDictionaryColumns(List<String> noDictionaryColumns) {
        this._noDictionaryColumns = noDictionaryColumns;
    }

    public void setnoDictionaryConfig(Map<String, String> noDictionaryConfig) {
        this._noDictionaryConfig = noDictionaryConfig;
    }

    public void setOnHeapDictionaryColumns(List<String> onHeapDictionaryColumns) {
        this._onHeapDictionaryColumns = onHeapDictionaryColumns;
    }

    public void setStarTreeIndexSpec(StarTreeIndexSpec starTreeIndexSpec) {
        this._starTreeIndexSpec = starTreeIndexSpec;
    }

    public StarTreeIndexSpec getStarTreeIndexSpec() {
        return this._starTreeIndexSpec;
    }

    public List<StarTreeIndexConfig> getStarTreeIndexConfigs() {
        return this._starTreeIndexConfigs;
    }

    public void setStarTreeIndexConfigs(List<StarTreeIndexConfig> starTreeIndexConfigs) {
        this._starTreeIndexConfigs = starTreeIndexConfigs;
    }

    public void setSegmentPartitionConfig(SegmentPartitionConfig config) {
        this._segmentPartitionConfig = config;
    }

    public void setAggregateMetrics(boolean value) {
        this._aggregateMetrics = value;
    }

    public SegmentPartitionConfig getSegmentPartitionConfig() {
        return this._segmentPartitionConfig;
    }

    public boolean isAggregateMetrics() {
        return this._aggregateMetrics;
    }

    public String toString() {
        Field[] fields;
        StringBuilder result = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        result.append(this.getClass().getName());
        result.append(" Object {");
        result.append(newLine);
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            block3: {
                result.append("  ");
                try {
                    result.append(field.getName());
                    result.append(": ");
                    result.append(field.get(this));
                }
                catch (IllegalAccessException ex) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("Caught exception while processing field " + field, (Throwable)ex);
                }
            }
            result.append(newLine);
        }
        result.append("}");
        return result.toString();
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        IndexingConfig that = (IndexingConfig)o;
        return EqualityUtils.isEqual(this._autoGeneratedInvertedIndex, that._autoGeneratedInvertedIndex) && EqualityUtils.isEqual(this._createInvertedIndexDuringSegmentGeneration, that._createInvertedIndexDuringSegmentGeneration) && EqualityUtils.isEqual(this._invertedIndexColumns, that._invertedIndexColumns) && EqualityUtils.isEqual(this._sortedColumn, that._sortedColumn) && EqualityUtils.isEqual(this._loadMode, that._loadMode) && EqualityUtils.isEqual(this._streamConfigs, that._streamConfigs) && EqualityUtils.isEqual(this._segmentFormatVersion, that._segmentFormatVersion) && EqualityUtils.isEqual(this._columnMinMaxValueGeneratorMode, that._columnMinMaxValueGeneratorMode) && EqualityUtils.isEqual(this._noDictionaryColumns, that._noDictionaryColumns) && EqualityUtils.isEqual(this._noDictionaryConfig, that._noDictionaryConfig) && EqualityUtils.isEqual(this._onHeapDictionaryColumns, that._onHeapDictionaryColumns) && EqualityUtils.isEqual(this._starTreeIndexSpec, that._starTreeIndexSpec) && EqualityUtils.isEqual(this._segmentPartitionConfig, that._segmentPartitionConfig) && EqualityUtils.isEqual(this._bloomFilterColumns, that._bloomFilterColumns);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._invertedIndexColumns);
        result = EqualityUtils.hashCodeOf(result, this._autoGeneratedInvertedIndex);
        result = EqualityUtils.hashCodeOf(result, this._createInvertedIndexDuringSegmentGeneration);
        result = EqualityUtils.hashCodeOf(result, this._sortedColumn);
        result = EqualityUtils.hashCodeOf(result, this._loadMode);
        result = EqualityUtils.hashCodeOf(result, this._streamConfigs);
        result = EqualityUtils.hashCodeOf(result, this._segmentFormatVersion);
        result = EqualityUtils.hashCodeOf(result, this._columnMinMaxValueGeneratorMode);
        result = EqualityUtils.hashCodeOf(result, this._noDictionaryColumns);
        result = EqualityUtils.hashCodeOf(result, this._noDictionaryConfig);
        result = EqualityUtils.hashCodeOf(result, this._onHeapDictionaryColumns);
        result = EqualityUtils.hashCodeOf(result, this._starTreeIndexSpec);
        result = EqualityUtils.hashCodeOf(result, this._segmentPartitionConfig);
        result = EqualityUtils.hashCodeOf(result, this._bloomFilterColumns);
        return result;
    }
}

