/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import io.vavr.Tuple;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import java.util.function.Function;
import org.apache.pinot.common.config.ChildKeyHandler;
import org.apache.pinot.common.config.Deserializer;
import org.apache.pinot.common.config.Serializer;

public class NamedListChildKeyHandler<T>
implements ChildKeyHandler<java.util.List<T>> {
    private Class<T> _type;

    protected NamedListChildKeyHandler(Class<T> type) {
        this._type = type;
    }

    @Override
    public java.util.List<T> handleChildKeys(Map<String, ?> childKeys, String pathPrefix) {
        Seq valueList = childKeys.groupBy(tuple2 -> ((String)tuple2._1).split("\\.", 2)[0]).flatMap(tuple2 -> {
            String key = (String)tuple2._1;
            Map values = (Map)tuple2._2;
            Map valuesWithoutPrefix = values.map((configKey, configValue) -> Tuple.of((Object)configKey.substring(key.length() + 1), (Object)configValue));
            valuesWithoutPrefix = valuesWithoutPrefix.put((Object)"name", (Object)key);
            try {
                T value = Deserializer.deserialize(this._type, valuesWithoutPrefix, "");
                return Option.some(value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return Option.none();
            }
        });
        return valueList.asJava();
    }

    @Override
    public Map<String, ?> unhandleChildKeys(java.util.List<T> values, String pathPrefix) {
        if (values == null) {
            return null;
        }
        return List.ofAll(values).flatMap(value -> {
            Map<String, ?> serializedValue = Serializer.serialize(value);
            String name = (String)serializedValue.getOrElse((Object)"name", null);
            return serializedValue.remove((Object)"name").mapKeys(key -> name + "." + key);
        }).toMap(Function.identity());
    }
}

