/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.pinot.common.config.ConfigDoc;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.utils.DataSize;
import org.apache.pinot.common.utils.EqualityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class QuotaConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuotaConfig.class);
    @ConfigKey(value="storage")
    @ConfigDoc(value="Storage allocated for this table", exampleValue="10 GiB")
    private String _storage;
    private String _maxQueriesPerSecond;

    @Nullable
    public String getStorage() {
        return this._storage;
    }

    public void setStorage(@Nullable String storage) {
        this._storage = storage;
    }

    @Nullable
    public String getMaxQueriesPerSecond() {
        return this._maxQueriesPerSecond;
    }

    public void setMaxQueriesPerSecond(@Nullable String maxQueriesPerSecond) {
        this._maxQueriesPerSecond = maxQueriesPerSecond;
    }

    public long storageSizeBytes() {
        return DataSize.toBytes(this._storage);
    }

    public void validate() {
        if (!this.isStorageValid()) {
            LOGGER.error("Failed to convert storage quota config: {} to bytes", (Object)this._storage);
            throw new ConfigurationRuntimeException("Failed to convert storage quota config: " + this._storage + " to bytes");
        }
        if (!this.isMaxQueriesPerSecondValid()) {
            LOGGER.error("Failed to convert qps quota config: {}", (Object)this._maxQueriesPerSecond);
            throw new ConfigurationRuntimeException("Failed to convert qps quota config: " + this._maxQueriesPerSecond);
        }
    }

    @JsonIgnore
    public boolean isStorageValid() {
        return this._storage == null || DataSize.toBytes(this._storage) >= 0L;
    }

    @JsonIgnore
    public boolean isMaxQueriesPerSecondValid() {
        Double qps = null;
        if (this._maxQueriesPerSecond != null) {
            try {
                qps = Double.parseDouble(this._maxQueriesPerSecond);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Failed to convert qps quota config: {}", (Object)this._maxQueriesPerSecond);
                return false;
            }
            if (qps <= 0.0) {
                LOGGER.error("Failed to convert qps quota config: {}", (Object)this._maxQueriesPerSecond);
                return false;
            }
        }
        return this._maxQueriesPerSecond == null || qps > 0.0;
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        QuotaConfig that = (QuotaConfig)o;
        return EqualityUtils.isEqual(this._storage, that._storage) && EqualityUtils.isEqual(this._maxQueriesPerSecond, that._maxQueriesPerSecond);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._storage);
        result = EqualityUtils.hashCodeOf(result, this._maxQueriesPerSecond);
        return result;
    }
}

