/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.common.config.ColumnPartitionConfig;
import org.apache.pinot.common.config.ColumnPartitionMapChildKeyHandler;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.config.UseChildKeyHandler;
import org.apache.pinot.common.utils.EqualityUtils;
import org.apache.pinot.common.utils.JsonUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SegmentPartitionConfig {
    public static final int INVALID_NUM_PARTITIONS = -1;
    @ConfigKey(value="columnPartitionMap")
    @UseChildKeyHandler(value=ColumnPartitionMapChildKeyHandler.class)
    private final Map<String, ColumnPartitionConfig> _columnPartitionMap;

    public SegmentPartitionConfig() {
        this._columnPartitionMap = null;
    }

    public SegmentPartitionConfig(@Nonnull @JsonProperty(value="columnPartitionMap") Map<String, ColumnPartitionConfig> columnPartitionMap) {
        Preconditions.checkNotNull(columnPartitionMap);
        this._columnPartitionMap = columnPartitionMap;
    }

    public Map<String, ColumnPartitionConfig> getColumnPartitionMap() {
        return this._columnPartitionMap;
    }

    @Nullable
    public String getFunctionName(@Nonnull String column) {
        ColumnPartitionConfig columnPartitionConfig = this._columnPartitionMap.get(column);
        return columnPartitionConfig != null ? columnPartitionConfig.getFunctionName() : null;
    }

    @JsonIgnore
    public void setNumPartitions(String column, int numPartitions) {
        ColumnPartitionConfig columnPartitionConfig = this._columnPartitionMap.get(column);
    }

    @JsonIgnore
    public void setNumPartitions(int numPartitions) {
        for (ColumnPartitionConfig columnPartitionConfig : this._columnPartitionMap.values()) {
            columnPartitionConfig.setNumPartitions(numPartitions);
        }
    }

    public static SegmentPartitionConfig fromJsonString(String jsonString) throws IOException {
        return JsonUtils.stringToObject(jsonString, SegmentPartitionConfig.class);
    }

    public String toJsonString() throws IOException {
        return JsonUtils.objectToString(this);
    }

    public int getNumPartitions(String column) {
        ColumnPartitionConfig config = this._columnPartitionMap.get(column);
        return config != null ? config.getNumPartitions() : -1;
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        SegmentPartitionConfig that = (SegmentPartitionConfig)o;
        return EqualityUtils.isEqual(this._columnPartitionMap, that._columnPartitionMap);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._columnPartitionMap);
        return result;
    }
}

