/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueFactory;
import io.vavr.Tuple;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.pinot.common.config.ChildKeyHandler;
import org.apache.pinot.common.config.ChildKeyTransformer;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.config.Deserializer;
import org.apache.pinot.common.config.NestedConfig;
import org.apache.pinot.common.config.SingleKeyDsl;
import org.apache.pinot.common.config.UseChildKeyHandler;
import org.apache.pinot.common.config.UseChildKeyTransformers;
import org.apache.pinot.common.config.UseDsl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Serializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Serializer.class);

    public static <T> Map<String, ?> serialize(T object) {
        try {
            if (object == null) {
                return null;
            }
            return Serializer.serialize(object, object.getClass(), "");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> String serializeToString(T object) {
        Config config = ConfigFactory.parseMap((java.util.Map)Serializer.serialize(object).toJavaMap());
        return config.root().render(ConfigRenderOptions.defaults().setJson(false).setOriginComments(false));
    }

    public static <T> String serializeToPropertiesString(T object) {
        ConfigRenderOptions configRenderOptions = ConfigRenderOptions.defaults().setJson(false).setOriginComments(false).setFormatted(false);
        return Serializer.serialize(object).map(keyValueTuple -> (String)keyValueTuple._1 + "=" + ConfigValueFactory.fromAnyRef((Object)keyValueTuple._2).render(configRenderOptions)).sorted().mkString((CharSequence)"\n");
    }

    private static <T> Map<String, ?> serialize(T object, Class<? extends T> clazz, String pathContext) throws Exception {
        if (object == null) {
            return HashMap.empty();
        }
        ConfigKey rootConfigKey = clazz.getAnnotation(ConfigKey.class);
        if (rootConfigKey != null) {
            pathContext = pathContext.isEmpty() ? rootConfigKey.value() : pathContext + "." + rootConfigKey.value();
        }
        Map values = HashMap.empty();
        HashMap dslValues = HashMap.empty();
        HashMap dslClasses = HashMap.empty();
        for (Field field : Serializer.getClassFields(clazz)) {
            ConfigKey configKey = field.getAnnotation(ConfigKey.class);
            NestedConfig nestedConfig = field.getAnnotation(NestedConfig.class);
            UseDsl useDsl = field.getAnnotation(UseDsl.class);
            UseChildKeyHandler useChildKeyHandler = field.getAnnotation(UseChildKeyHandler.class);
            if (configKey == null && nestedConfig == null) continue;
            field.setAccessible(true);
            if (configKey != null) {
                String keyName = pathContext.isEmpty() ? configKey.value() : pathContext + "." + configKey.value();
                if (useDsl != null) {
                    Map dslValue = (Map)dslValues.getOrElse((Object)keyName, (Object)HashMap.empty());
                    dslValue = dslValue.put((Object)useDsl.value(), field.get(object));
                    dslValues = dslValues.put((Object)keyName, (Object)dslValue);
                    dslClasses = dslClasses.put((Object)keyName, useDsl.dsl());
                    continue;
                }
                if (useChildKeyHandler != null) {
                    ChildKeyHandler childKeyHandler = useChildKeyHandler.value().newInstance();
                    Map serializedChildMap = childKeyHandler.unhandleChildKeys(field.get(object), keyName);
                    if (serializedChildMap == null) continue;
                    serializedChildMap = serializedChildMap.map((key, value) -> Tuple.of((Object)(keyName + "." + key), (Object)value));
                    values = values.merge(serializedChildMap);
                    continue;
                }
                if (Deserializer.isSimpleType(field.getType())) {
                    values = Serializer.storeSimpleFieldIntoMap(field.get(object), field.getType(), keyName, values);
                    continue;
                }
                values = values.merge(Serializer.serialize(field.get(object), field.getType(), keyName));
                continue;
            }
            if (nestedConfig == null) continue;
            values = values.merge(Serializer.serialize(field.get(object), field.getType(), pathContext));
        }
        HashMap finalDslClasses = dslClasses;
        Map dslUnparsedValues = dslValues.flatMap((arg_0, arg_1) -> Serializer.lambda$serialize$59((Map)finalDslClasses, arg_0, arg_1));
        values = values.merge(dslUnparsedValues);
        UseChildKeyTransformers useChildKeyTransformers = clazz.getAnnotation(UseChildKeyTransformers.class);
        if (useChildKeyTransformers != null) {
            List reversedChildKeyTransformers = List.ofAll(Arrays.asList(useChildKeyTransformers.value())).reverse();
            for (Class childKeyTransformerClass : reversedChildKeyTransformers) {
                LOGGER.debug("Using child key transformer {} on the root config {}", (Object)childKeyTransformerClass, (Object)values);
                ChildKeyTransformer childKeyTransformer = (ChildKeyTransformer)childKeyTransformerClass.newInstance();
                values = childKeyTransformer.unapply(values, pathContext);
                LOGGER.debug("Config after child key transformation {}", values);
            }
        }
        return values;
    }

    private static List<Field> getClassFields(Class<?> clazz) {
        List fields = List.of((Object[])clazz.getDeclaredFields());
        while (clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            fields = fields.appendAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        return fields;
    }

    private static Map<String, Object> storeSimpleFieldIntoMap(Object object, Class<?> type, String keyName, Map<String, Object> values) {
        if (object == null) {
            return values;
        }
        if (Enum.class.isAssignableFrom(type)) {
            object = object.toString();
        }
        return values.put((Object)keyName, object);
    }

    private static /* synthetic */ Iterable lambda$serialize$59(Map map, String configKey, Map dslValueData) {
        try {
            Class dslClass = (Class)map.getOrElse((Object)configKey, null);
            SingleKeyDsl dslInstance = (SingleKeyDsl)dslClass.newInstance();
            Class<?> dslValueType = dslClass.getMethod("parse", String.class).getReturnType();
            Object dslValueObject = Deserializer.deserialize(dslValueType, dslValueData, "");
            if (dslValueObject != null) {
                String unparsedValue = dslInstance.unparse(dslValueObject);
                if (unparsedValue != null) {
                    return List.of((Object)Tuple.of((Object)configKey, (Object)unparsedValue));
                }
                return List.empty();
            }
            return List.empty();
        }
        catch (Exception e) {
            LOGGER.warn("Caught exception while serializing field for configKey {}", (Object)e, (Object)configKey);
            return List.empty();
        }
    }
}

