/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.helix.ZNRecord;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.common.config.ConfigDoc;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.config.IndexingConfig;
import org.apache.pinot.common.config.NestedConfig;
import org.apache.pinot.common.config.QuotaConfig;
import org.apache.pinot.common.config.RoutingConfig;
import org.apache.pinot.common.config.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.common.config.StreamConsumptionConfig;
import org.apache.pinot.common.config.TableCustomConfig;
import org.apache.pinot.common.config.TableNameBuilder;
import org.apache.pinot.common.config.TableTaskConfig;
import org.apache.pinot.common.config.TagOverrideConfig;
import org.apache.pinot.common.config.TenantConfig;
import org.apache.pinot.common.data.StarTreeIndexSpec;
import org.apache.pinot.common.utils.CommonConstants;
import org.apache.pinot.common.utils.EqualityUtils;
import org.apache.pinot.common.utils.JsonUtils;
import org.apache.pinot.startree.hll.HllConfig;

@ConfigDoc(value="Configuration for a table", mandatory=true)
@ConfigKey(value="table")
public class TableConfig {
    public static final String TABLE_NAME_KEY = "tableName";
    public static final String TABLE_TYPE_KEY = "tableType";
    public static final String VALIDATION_CONFIG_KEY = "segmentsConfig";
    public static final String TENANT_CONFIG_KEY = "tenants";
    public static final String INDEXING_CONFIG_KEY = "tableIndexConfig";
    public static final String CUSTOM_CONFIG_KEY = "metadata";
    public static final String QUOTA_CONFIG_KEY = "quota";
    public static final String TASK_CONFIG_KEY = "task";
    public static final String ROUTING_CONFIG_KEY = "routing";
    @ConfigKey(value="name")
    @ConfigDoc(value="The name for the table.", mandatory=true, exampleValue="myTable")
    private String _tableName;
    @ConfigKey(value="type")
    @ConfigDoc(value="The type of the table, either realtime or offline", mandatory=true)
    private CommonConstants.Helix.TableType _tableType;
    @NestedConfig
    private SegmentsValidationAndRetentionConfig _validationConfig;
    @NestedConfig
    private TenantConfig _tenantConfig;
    @NestedConfig
    private IndexingConfig _indexingConfig;
    @NestedConfig
    private TableCustomConfig _customConfig;
    @ConfigKey(value="quota")
    @ConfigDoc(value="Resource quota associated with this table")
    private QuotaConfig _quotaConfig;
    @NestedConfig
    private TableTaskConfig _taskConfig;
    @NestedConfig
    private RoutingConfig _routingConfig;

    public TableConfig() {
        this._tenantConfig = new TenantConfig();
        this._customConfig = new TableCustomConfig();
    }

    private TableConfig(@Nonnull String tableName, @Nonnull CommonConstants.Helix.TableType tableType, @Nonnull SegmentsValidationAndRetentionConfig validationConfig, @Nonnull TenantConfig tenantConfig, @Nonnull IndexingConfig indexingConfig, @Nonnull TableCustomConfig customConfig, @Nullable QuotaConfig quotaConfig, @Nullable TableTaskConfig taskConfig, @Nullable RoutingConfig routingConfig) {
        this._tableName = TableNameBuilder.forType(tableType).tableNameWithType(tableName);
        this._tableType = tableType;
        this._validationConfig = validationConfig;
        this._tenantConfig = tenantConfig;
        this._indexingConfig = indexingConfig;
        this._customConfig = customConfig;
        this._quotaConfig = quotaConfig;
        this._taskConfig = taskConfig;
        this._routingConfig = routingConfig;
    }

    @Deprecated
    @Nonnull
    public static TableConfig init(@Nonnull String jsonConfigString) throws IOException {
        return TableConfig.fromJsonString(jsonConfigString);
    }

    public static TableConfig fromJsonString(String jsonString) throws IOException {
        return TableConfig.fromJSONConfig(JsonUtils.stringToJsonNode(jsonString));
    }

    @Nonnull
    public static TableConfig fromJSONConfig(@Nonnull JsonNode jsonConfig) throws IOException {
        CommonConstants.Helix.TableType tableType = CommonConstants.Helix.TableType.valueOf(jsonConfig.get(TABLE_TYPE_KEY).asText().toUpperCase());
        String tableName = TableNameBuilder.forType(tableType).tableNameWithType(jsonConfig.get(TABLE_NAME_KEY).asText());
        SegmentsValidationAndRetentionConfig validationConfig = TableConfig.extractChildConfig(jsonConfig, VALIDATION_CONFIG_KEY, SegmentsValidationAndRetentionConfig.class);
        TenantConfig tenantConfig = TableConfig.extractChildConfig(jsonConfig, TENANT_CONFIG_KEY, TenantConfig.class);
        IndexingConfig indexingConfig = TableConfig.extractChildConfig(jsonConfig, INDEXING_CONFIG_KEY, IndexingConfig.class);
        TableCustomConfig customConfig = TableConfig.extractChildConfig(jsonConfig, CUSTOM_CONFIG_KEY, TableCustomConfig.class);
        QuotaConfig quotaConfig = null;
        if (jsonConfig.has(QUOTA_CONFIG_KEY)) {
            quotaConfig = TableConfig.extractChildConfig(jsonConfig, QUOTA_CONFIG_KEY, QuotaConfig.class);
            quotaConfig.validate();
        }
        TableTaskConfig taskConfig = null;
        if (jsonConfig.has(TASK_CONFIG_KEY)) {
            taskConfig = TableConfig.extractChildConfig(jsonConfig, TASK_CONFIG_KEY, TableTaskConfig.class);
        }
        RoutingConfig routingConfig = null;
        if (jsonConfig.has(ROUTING_CONFIG_KEY)) {
            routingConfig = TableConfig.extractChildConfig(jsonConfig, ROUTING_CONFIG_KEY, RoutingConfig.class);
        }
        return new TableConfig(tableName, tableType, validationConfig, tenantConfig, indexingConfig, customConfig, quotaConfig, taskConfig, routingConfig);
    }

    private static <T> T extractChildConfig(JsonNode jsonConfig, String childConfigKey, Class<T> childConfigClass) throws IOException {
        JsonNode childConfigNode = jsonConfig.get(childConfigKey);
        if (childConfigNode.isObject()) {
            return JsonUtils.jsonNodeToObject(childConfigNode, childConfigClass);
        }
        return JsonUtils.stringToObject(childConfigNode.asText(), childConfigClass);
    }

    @Nonnull
    public static JsonNode toJSONConfig(@Nonnull TableConfig tableConfig) {
        ObjectNode jsonConfig = JsonUtils.newObjectNode();
        jsonConfig.put(TABLE_NAME_KEY, tableConfig._tableName);
        jsonConfig.put(TABLE_TYPE_KEY, tableConfig._tableType.toString());
        jsonConfig.set(VALIDATION_CONFIG_KEY, JsonUtils.objectToJsonNode(tableConfig._validationConfig));
        jsonConfig.set(TENANT_CONFIG_KEY, JsonUtils.objectToJsonNode(tableConfig._tenantConfig));
        jsonConfig.set(INDEXING_CONFIG_KEY, JsonUtils.objectToJsonNode(tableConfig._indexingConfig));
        jsonConfig.set(CUSTOM_CONFIG_KEY, JsonUtils.objectToJsonNode(tableConfig._customConfig));
        if (tableConfig._quotaConfig != null) {
            jsonConfig.set(QUOTA_CONFIG_KEY, JsonUtils.objectToJsonNode(tableConfig._quotaConfig));
        }
        if (tableConfig._taskConfig != null) {
            jsonConfig.set(TASK_CONFIG_KEY, JsonUtils.objectToJsonNode(tableConfig._taskConfig));
        }
        if (tableConfig._routingConfig != null) {
            jsonConfig.set(ROUTING_CONFIG_KEY, JsonUtils.objectToJsonNode(tableConfig._routingConfig));
        }
        return jsonConfig;
    }

    @Nonnull
    public static TableConfig fromZnRecord(@Nonnull ZNRecord znRecord) throws IOException {
        Map simpleFields = znRecord.getSimpleFields();
        CommonConstants.Helix.TableType tableType = CommonConstants.Helix.TableType.valueOf(((String)simpleFields.get(TABLE_TYPE_KEY)).toUpperCase());
        String tableName = TableNameBuilder.forType(tableType).tableNameWithType((String)simpleFields.get(TABLE_NAME_KEY));
        SegmentsValidationAndRetentionConfig validationConfig = JsonUtils.stringToObject((String)simpleFields.get(VALIDATION_CONFIG_KEY), SegmentsValidationAndRetentionConfig.class);
        TenantConfig tenantConfig = JsonUtils.stringToObject((String)simpleFields.get(TENANT_CONFIG_KEY), TenantConfig.class);
        IndexingConfig indexingConfig = JsonUtils.stringToObject((String)simpleFields.get(INDEXING_CONFIG_KEY), IndexingConfig.class);
        TableCustomConfig customConfig = JsonUtils.stringToObject((String)simpleFields.get(CUSTOM_CONFIG_KEY), TableCustomConfig.class);
        QuotaConfig quotaConfig = null;
        String quotaConfigString = (String)simpleFields.get(QUOTA_CONFIG_KEY);
        if (quotaConfigString != null) {
            quotaConfig = JsonUtils.stringToObject(quotaConfigString, QuotaConfig.class);
            quotaConfig.validate();
        }
        TableTaskConfig taskConfig = null;
        String taskConfigString = (String)simpleFields.get(TASK_CONFIG_KEY);
        if (taskConfigString != null) {
            taskConfig = JsonUtils.stringToObject(taskConfigString, TableTaskConfig.class);
        }
        String routingConfigString = (String)simpleFields.get(ROUTING_CONFIG_KEY);
        RoutingConfig routingConfig = null;
        if (routingConfigString != null) {
            routingConfig = JsonUtils.stringToObject(routingConfigString, RoutingConfig.class);
        }
        return new TableConfig(tableName, tableType, validationConfig, tenantConfig, indexingConfig, customConfig, quotaConfig, taskConfig, routingConfig);
    }

    @Nonnull
    public static ZNRecord toZnRecord(@Nonnull TableConfig tableConfig) {
        ZNRecord znRecord = new ZNRecord(tableConfig.getTableName());
        HashMap<String, String> simpleFields = new HashMap<String, String>();
        simpleFields.put(TABLE_NAME_KEY, tableConfig._tableName);
        simpleFields.put(TABLE_TYPE_KEY, tableConfig._tableType.toString());
        try {
            simpleFields.put(VALIDATION_CONFIG_KEY, JsonUtils.objectToString(tableConfig._validationConfig));
            simpleFields.put(TENANT_CONFIG_KEY, JsonUtils.objectToString(tableConfig._tenantConfig));
            simpleFields.put(INDEXING_CONFIG_KEY, JsonUtils.objectToString(tableConfig._indexingConfig));
            simpleFields.put(CUSTOM_CONFIG_KEY, JsonUtils.objectToString(tableConfig._customConfig));
            if (tableConfig._quotaConfig != null) {
                simpleFields.put(QUOTA_CONFIG_KEY, JsonUtils.objectToString(tableConfig._quotaConfig));
            }
            if (tableConfig._taskConfig != null) {
                simpleFields.put(TASK_CONFIG_KEY, JsonUtils.objectToString(tableConfig._taskConfig));
            }
            if (tableConfig._routingConfig != null) {
                simpleFields.put(ROUTING_CONFIG_KEY, JsonUtils.objectToString(tableConfig._routingConfig));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        znRecord.setSimpleFields(simpleFields);
        return znRecord;
    }

    @Nonnull
    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(@Nonnull String tableName) {
        this._tableName = tableName;
    }

    @Nonnull
    public CommonConstants.Helix.TableType getTableType() {
        return this._tableType;
    }

    public void setTableType(@Nonnull CommonConstants.Helix.TableType tableType) {
        this._tableType = tableType;
    }

    @Nonnull
    public SegmentsValidationAndRetentionConfig getValidationConfig() {
        return this._validationConfig;
    }

    public void setValidationConfig(@Nonnull SegmentsValidationAndRetentionConfig validationConfig) {
        this._validationConfig = validationConfig;
    }

    @Nonnull
    public TenantConfig getTenantConfig() {
        return this._tenantConfig;
    }

    public void setTenantConfig(@Nonnull TenantConfig tenantConfig) {
        this._tenantConfig = tenantConfig;
    }

    @Nonnull
    public IndexingConfig getIndexingConfig() {
        return this._indexingConfig;
    }

    public void setIndexingConfig(@Nonnull IndexingConfig indexingConfig) {
        this._indexingConfig = indexingConfig;
    }

    @Nonnull
    public TableCustomConfig getCustomConfig() {
        return this._customConfig;
    }

    public void setCustomConfig(@Nonnull TableCustomConfig customConfig) {
        this._customConfig = customConfig;
    }

    @Nullable
    public QuotaConfig getQuotaConfig() {
        return this._quotaConfig;
    }

    public void setQuotaConfig(@Nullable QuotaConfig quotaConfig) {
        this._quotaConfig = quotaConfig;
    }

    @Nullable
    public TableTaskConfig getTaskConfig() {
        return this._taskConfig;
    }

    public void setTaskConfig(@Nullable TableTaskConfig taskConfig) {
        this._taskConfig = taskConfig;
    }

    @Nullable
    public RoutingConfig getRoutingConfig() {
        return this._routingConfig;
    }

    public void setRoutingConfig(RoutingConfig routingConfig) {
        this._routingConfig = routingConfig;
    }

    @Nonnull
    public String toJSONConfigString() throws IOException {
        return TableConfig.toJSONConfig(this).toString();
    }

    public String toString() {
        try {
            return JsonUtils.objectToPrettyString(TableConfig.toJSONConfig(this));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TableConfig) {
            TableConfig that = (TableConfig)obj;
            return EqualityUtils.isEqual(this._tableName, that._tableName) && EqualityUtils.isEqual((Object)this._tableType, (Object)that._tableType) && EqualityUtils.isEqual(this._validationConfig, that._validationConfig) && EqualityUtils.isEqual(this._tenantConfig, that._tenantConfig) && EqualityUtils.isEqual(this._indexingConfig, that._indexingConfig) && EqualityUtils.isEqual(this._customConfig, that._customConfig) && EqualityUtils.isEqual(this._quotaConfig, that._quotaConfig) && EqualityUtils.isEqual(this._taskConfig, that._taskConfig) && EqualityUtils.isEqual(this._routingConfig, that._routingConfig);
        }
        return false;
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._tableName);
        result = EqualityUtils.hashCodeOf(result, (Object)this._tableType);
        result = EqualityUtils.hashCodeOf(result, this._validationConfig);
        result = EqualityUtils.hashCodeOf(result, this._tenantConfig);
        result = EqualityUtils.hashCodeOf(result, this._indexingConfig);
        result = EqualityUtils.hashCodeOf(result, this._customConfig);
        result = EqualityUtils.hashCodeOf(result, this._quotaConfig);
        result = EqualityUtils.hashCodeOf(result, this._taskConfig);
        result = EqualityUtils.hashCodeOf(result, this._routingConfig);
        return result;
    }

    public static class Builder {
        private static final String DEFAULT_SEGMENT_PUSH_TYPE = "APPEND";
        private static final String REFRESH_SEGMENT_PUSH_TYPE = "REFRESH";
        private static final String DEFAULT_SEGMENT_ASSIGNMENT_STRATEGY = "BalanceNumSegmentAssignmentStrategy";
        private static final String DEFAULT_STREAM_PARTITION_ASSIGNMENT_STRATEGY = "UniformStreamPartitionAssignment";
        private static final String DEFAULT_NUM_REPLICAS = "1";
        private static final String DEFAULT_LOAD_MODE = "HEAP";
        private static final String MMAP_LOAD_MODE = "MMAP";
        private final CommonConstants.Helix.TableType _tableType;
        private String _tableName;
        private boolean _isLLC;
        private String _timeColumnName;
        private String _timeType;
        private String _retentionTimeUnit;
        private String _retentionTimeValue;
        private String _segmentPushFrequency;
        private String _segmentPushType = "APPEND";
        private String _segmentAssignmentStrategy = "BalanceNumSegmentAssignmentStrategy";
        private String _schemaName;
        private String _numReplicas = "1";
        private String _brokerTenant;
        private String _serverTenant;
        private TagOverrideConfig _tagOverrideConfig;
        private String _loadMode = "HEAP";
        private String _segmentVersion;
        private String _sortedColumn;
        private List<String> _invertedIndexColumns;
        private List<String> _noDictionaryColumns;
        private List<String> _onHeapDictionaryColumns;
        private List<String> _bloomFilterColumns;
        private Map<String, String> _streamConfigs;
        private String _streamPartitionAssignmentStrategy = "UniformStreamPartitionAssignment";
        private TableCustomConfig _customConfig;
        private QuotaConfig _quotaConfig;
        private TableTaskConfig _taskConfig;
        private RoutingConfig _routingConfig;
        private HllConfig _hllConfig;
        private StarTreeIndexSpec _starTreeIndexSpec;

        public Builder(CommonConstants.Helix.TableType tableType) {
            this._tableType = tableType;
        }

        public Builder setTableName(String tableName) {
            this._tableName = tableName;
            return this;
        }

        public Builder setLLC(boolean isLLC) {
            Preconditions.checkState(this._tableType == CommonConstants.Helix.TableType.REALTIME);
            this._isLLC = isLLC;
            return this;
        }

        public Builder setTimeColumnName(String timeColumnName) {
            this._timeColumnName = timeColumnName;
            return this;
        }

        public Builder setTimeType(String timeType) {
            this._timeType = timeType;
            return this;
        }

        public Builder setRetentionTimeUnit(String retentionTimeUnit) {
            this._retentionTimeUnit = retentionTimeUnit;
            return this;
        }

        public Builder setRetentionTimeValue(String retentionTimeValue) {
            this._retentionTimeValue = retentionTimeValue;
            return this;
        }

        public Builder setSegmentPushType(String segmentPushType) {
            this._segmentPushType = REFRESH_SEGMENT_PUSH_TYPE.equalsIgnoreCase(segmentPushType) ? REFRESH_SEGMENT_PUSH_TYPE : DEFAULT_SEGMENT_PUSH_TYPE;
            return this;
        }

        public Builder setSegmentPushFrequency(String segmentPushFrequency) {
            this._segmentPushFrequency = segmentPushFrequency;
            return this;
        }

        public Builder setSegmentAssignmentStrategy(String segmentAssignmentStrategy) {
            this._segmentAssignmentStrategy = segmentAssignmentStrategy;
            return this;
        }

        public Builder setSchemaName(String schemaName) {
            this._schemaName = schemaName;
            return this;
        }

        public Builder setNumReplicas(int numReplicas) {
            Preconditions.checkArgument(numReplicas > 0);
            this._numReplicas = String.valueOf(numReplicas);
            return this;
        }

        public Builder setBrokerTenant(String brokerTenant) {
            this._brokerTenant = brokerTenant;
            return this;
        }

        public Builder setServerTenant(String serverTenant) {
            this._serverTenant = serverTenant;
            return this;
        }

        public Builder setTagOverrideConfig(TagOverrideConfig tagOverrideConfig) {
            this._tagOverrideConfig = tagOverrideConfig;
            return this;
        }

        public Builder setLoadMode(String loadMode) {
            this._loadMode = MMAP_LOAD_MODE.equalsIgnoreCase(loadMode) ? MMAP_LOAD_MODE : DEFAULT_LOAD_MODE;
            return this;
        }

        public Builder setSegmentVersion(String segmentVersion) {
            this._segmentVersion = segmentVersion;
            return this;
        }

        public Builder setSortedColumn(String sortedColumn) {
            this._sortedColumn = sortedColumn;
            return this;
        }

        public Builder setInvertedIndexColumns(List<String> invertedIndexColumns) {
            this._invertedIndexColumns = invertedIndexColumns;
            return this;
        }

        public Builder setBloomFilterColumns(List<String> bloomFilterColumns) {
            this._bloomFilterColumns = bloomFilterColumns;
            return this;
        }

        public Builder setNoDictionaryColumns(List<String> noDictionaryColumns) {
            this._noDictionaryColumns = noDictionaryColumns;
            return this;
        }

        public Builder setOnHeapDictionaryColumns(List<String> onHeapDictionaryColumns) {
            this._onHeapDictionaryColumns = onHeapDictionaryColumns;
            return this;
        }

        public Builder setStreamPartitionAssignmentStrategy(String streamPartitionAssignmentStrategy) {
            this._streamPartitionAssignmentStrategy = streamPartitionAssignmentStrategy;
            return this;
        }

        public Builder setStreamConfigs(Map<String, String> streamConfigs) {
            Preconditions.checkState(this._tableType == CommonConstants.Helix.TableType.REALTIME);
            this._streamConfigs = streamConfigs;
            return this;
        }

        public Builder setCustomConfig(TableCustomConfig customConfig) {
            this._customConfig = customConfig;
            return this;
        }

        public Builder setQuotaConfig(QuotaConfig quotaConfig) {
            this._quotaConfig = quotaConfig;
            return this;
        }

        public Builder setTaskConfig(TableTaskConfig taskConfig) {
            this._taskConfig = taskConfig;
            return this;
        }

        public Builder setRoutingConfig(RoutingConfig routingConfig) {
            this._routingConfig = routingConfig;
            return this;
        }

        public TableConfig build() {
            SegmentsValidationAndRetentionConfig validationConfig = new SegmentsValidationAndRetentionConfig();
            validationConfig.setTimeColumnName(this._timeColumnName);
            validationConfig.setTimeType(this._timeType);
            validationConfig.setRetentionTimeUnit(this._retentionTimeUnit);
            validationConfig.setRetentionTimeValue(this._retentionTimeValue);
            validationConfig.setSegmentPushFrequency(this._segmentPushFrequency);
            validationConfig.setSegmentPushType(this._segmentPushType);
            validationConfig.setSegmentAssignmentStrategy(this._segmentAssignmentStrategy);
            validationConfig.setSchemaName(this._schemaName);
            validationConfig.setReplication(this._numReplicas);
            if (this._isLLC) {
                validationConfig.setReplicasPerPartition(this._numReplicas);
            }
            TenantConfig tenantConfig = new TenantConfig();
            tenantConfig.setBroker(this._brokerTenant);
            tenantConfig.setServer(this._serverTenant);
            tenantConfig.setTagOverrideConfig(this._tagOverrideConfig);
            IndexingConfig indexingConfig = new IndexingConfig();
            indexingConfig.setLoadMode(this._loadMode);
            indexingConfig.setSegmentFormatVersion(this._segmentVersion);
            if (this._sortedColumn != null) {
                indexingConfig.setSortedColumn(Collections.singletonList(this._sortedColumn));
            }
            indexingConfig.setInvertedIndexColumns(this._invertedIndexColumns);
            indexingConfig.setNoDictionaryColumns(this._noDictionaryColumns);
            indexingConfig.setOnHeapDictionaryColumns(this._onHeapDictionaryColumns);
            indexingConfig.setStreamConfigs(this._streamConfigs);
            indexingConfig.setBloomFilterColumns(this._bloomFilterColumns);
            StreamConsumptionConfig streamConsumptionConfig = new StreamConsumptionConfig();
            streamConsumptionConfig.setStreamPartitionAssignmentStrategy(this._streamPartitionAssignmentStrategy);
            indexingConfig.setStreamConsumptionConfig(streamConsumptionConfig);
            if (this._customConfig == null) {
                this._customConfig = new TableCustomConfig();
                this._customConfig.setCustomConfigs(new HashMap<String, String>());
            }
            return new TableConfig(this._tableName, this._tableType, validationConfig, tenantConfig, indexingConfig, this._customConfig, this._quotaConfig, this._taskConfig, this._routingConfig);
        }
    }
}

