/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.config.SimpleMapChildKeyHandler;
import org.apache.pinot.common.config.UseChildKeyHandler;
import org.apache.pinot.common.utils.EqualityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TableCustomConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableCustomConfig.class);
    public static final String MESSAGE_BASED_REFRESH_KEY = "messageBasedRefresh";
    @ConfigKey(value="customConfigs")
    @UseChildKeyHandler(value=SimpleMapChildKeyHandler.class)
    private Map<String, String> _customConfigs;

    public Map<String, String> getCustomConfigs() {
        return this._customConfigs;
    }

    public void setCustomConfigs(Map<String, String> customConfigs) {
        this._customConfigs = customConfigs;
    }

    public String toString() {
        Field[] fields;
        StringBuilder result = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        result.append(this.getClass().getName());
        result.append(" Object {");
        result.append(newLine);
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            block3: {
                result.append("  ");
                try {
                    result.append(field.getName());
                    result.append(": ");
                    result.append(field.get(this));
                }
                catch (IllegalAccessException ex) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("Caught exception while processing field " + field, (Throwable)ex);
                }
            }
            result.append(newLine);
        }
        result.append("}");
        return result.toString();
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        TableCustomConfig that = (TableCustomConfig)o;
        return EqualityUtils.isEqual(this._customConfigs, that._customConfigs);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._customConfigs);
        return result;
    }
}

