/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import org.apache.pinot.common.utils.ServerType;
import org.apache.pinot.common.utils.TenantRole;

public class TagNameUtils {
    public static final String DEFAULT_TENANT_NAME = "DefaultTenant";

    private static String buildRealtimeTagFromTenantName(String tenantName) {
        return tenantName + "_" + ServerType.REALTIME.toString();
    }

    private static String buildOfflineTagFromTenantName(String tenantName) {
        return tenantName + "_" + ServerType.OFFLINE.toString();
    }

    private static String buildBrokerTenantTagFromTenantName(String tenantName) {
        return tenantName + "_" + TenantRole.BROKER.toString();
    }

    public static boolean hasValidServerTagSuffix(String tagName) {
        return tagName.endsWith(ServerType.REALTIME.toString()) || tagName.endsWith(ServerType.OFFLINE.toString());
    }

    public static TenantRole getTenantRoleFromTag(String tagName) {
        if (tagName.endsWith(ServerType.REALTIME.toString())) {
            return TenantRole.SERVER;
        }
        if (tagName.endsWith(ServerType.OFFLINE.toString())) {
            return TenantRole.SERVER;
        }
        if (tagName.endsWith(TenantRole.BROKER.toString())) {
            return TenantRole.BROKER;
        }
        throw new RuntimeException("Cannot identify tenant type from tag name : " + tagName);
    }

    public static String getTagFromTenantAndServerType(String tenantName, ServerType type) {
        if (type == ServerType.OFFLINE) {
            return TagNameUtils.getOfflineTagForTenant(tenantName);
        }
        return TagNameUtils.getRealtimeTagForTenant(tenantName);
    }

    public static String getRealtimeTagForTenant(String tenantName) {
        if (tenantName == null) {
            return TagNameUtils.getRealtimeTagForTenant(DEFAULT_TENANT_NAME);
        }
        if (tenantName.endsWith(ServerType.REALTIME.toString())) {
            return tenantName;
        }
        return TagNameUtils.buildRealtimeTagFromTenantName(tenantName);
    }

    public static String getOfflineTagForTenant(String tenantName) {
        if (tenantName == null) {
            return TagNameUtils.getOfflineTagForTenant(DEFAULT_TENANT_NAME);
        }
        if (tenantName.endsWith(ServerType.OFFLINE.toString())) {
            return tenantName;
        }
        return TagNameUtils.buildOfflineTagFromTenantName(tenantName);
    }

    public static String getBrokerTagForTenant(String tenantName) {
        if (tenantName == null) {
            return TagNameUtils.getBrokerTagForTenant(DEFAULT_TENANT_NAME);
        }
        if (tenantName.endsWith(TenantRole.BROKER.toString())) {
            return tenantName;
        }
        return TagNameUtils.buildBrokerTenantTagFromTenantName(tenantName);
    }

    public static String getTenantNameFromTag(String tag) {
        if (tag.endsWith(ServerType.REALTIME.toString())) {
            return tag.substring(0, tag.length() - (ServerType.REALTIME.toString().length() + 1));
        }
        if (tag.endsWith(ServerType.OFFLINE.toString())) {
            return tag.substring(0, tag.length() - (ServerType.OFFLINE.toString().length() + 1));
        }
        if (tag.endsWith(TenantRole.BROKER.toString())) {
            return tag.substring(0, tag.length() - (TenantRole.BROKER.toString().length() + 1));
        }
        return tag;
    }
}

