/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.pinot.common.utils.EqualityUtils;
import org.apache.pinot.common.utils.TenantRole;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Tenant {
    private TenantRole _tenantRole;
    private String _tenantName;
    private int _numberOfInstances = 0;
    private int _offlineInstances = 0;
    private int _realtimeInstances = 0;

    public TenantRole getTenantRole() {
        return this._tenantRole;
    }

    public void setTenantRole(TenantRole tenantRole) {
        this._tenantRole = tenantRole;
    }

    public String getTenantName() {
        return this._tenantName;
    }

    public void setTenantName(String tenantName) {
        this._tenantName = tenantName;
    }

    public int getNumberOfInstances() {
        return this._numberOfInstances;
    }

    public void setNumberOfInstances(int numberOfInstances) {
        this._numberOfInstances = numberOfInstances;
    }

    public int getOfflineInstances() {
        return this._offlineInstances;
    }

    public void setOfflineInstances(int offlineInstances) {
        this._offlineInstances = offlineInstances;
    }

    public int getRealtimeInstances() {
        return this._realtimeInstances;
    }

    public void setRealtimeInstances(int realtimeInstances) {
        this._realtimeInstances = realtimeInstances;
    }

    @JsonIgnore
    public boolean isCoLocated() {
        return this._realtimeInstances + this._offlineInstances > this._numberOfInstances;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tenant) {
            Tenant that = (Tenant)obj;
            return EqualityUtils.isEqual(this._numberOfInstances, that._numberOfInstances) && EqualityUtils.isEqual(this._offlineInstances, that._offlineInstances) && EqualityUtils.isEqual(this._realtimeInstances, that._realtimeInstances) && EqualityUtils.isEqual((Object)this._tenantRole, (Object)that._tenantRole) && EqualityUtils.isEqual(this._tenantName, that._tenantName);
        }
        return false;
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf((Object)this._tenantRole);
        result = EqualityUtils.hashCodeOf(result, this._tenantName);
        result = EqualityUtils.hashCodeOf(result, this._numberOfInstances);
        result = EqualityUtils.hashCodeOf(result, this._offlineInstances);
        result = EqualityUtils.hashCodeOf(result, this._realtimeInstances);
        return result;
    }

    public static class TenantBuilder {
        Tenant tenant = new Tenant();

        public TenantBuilder(String name) {
            this.tenant.setTenantName(name);
        }

        public TenantBuilder setRole(TenantRole role) {
            this.tenant.setTenantRole(role);
            return this;
        }

        public TenantBuilder setTotalInstances(int totalInstances) {
            this.tenant.setNumberOfInstances(totalInstances);
            return this;
        }

        public TenantBuilder setOfflineInstances(int totalInstances) {
            this.tenant.setOfflineInstances(totalInstances);
            return this;
        }

        public TenantBuilder setRealtimeInstances(int totalInstances) {
            this.tenant.setRealtimeInstances(totalInstances);
            return this;
        }

        public Tenant build() {
            this.tenant.isCoLocated();
            return this.tenant;
        }
    }
}

