/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.data.DateTimeFormatSpec;
import org.apache.pinot.common.data.DateTimeGranularitySpec;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.utils.EqualityUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class DateTimeFieldSpec
extends FieldSpec {
    @ConfigKey(value="format")
    private String _format;
    @ConfigKey(value="granularity")
    private String _granularity;

    public DateTimeFieldSpec() {
    }

    public DateTimeFieldSpec(@Nonnull String name, @Nonnull FieldSpec.DataType dataType, @Nonnull String format, @Nonnull String granularity) {
        super(name, dataType, true);
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(dataType);
        Preconditions.checkArgument(DateTimeFormatSpec.isValidFormat(format));
        Preconditions.checkArgument(DateTimeGranularitySpec.isValidGranularity(granularity));
        this._format = format;
        this._granularity = granularity;
    }

    @Override
    @JsonIgnore
    @Nonnull
    public FieldSpec.FieldType getFieldType() {
        return FieldSpec.FieldType.DATE_TIME;
    }

    @Override
    public void setSingleValueField(boolean isSingleValueField) {
        Preconditions.checkArgument(isSingleValueField, "Unsupported multi-value for date time field.");
    }

    @Nonnull
    public String getFormat() {
        return this._format;
    }

    public void setFormat(@Nonnull String format) {
        this._format = format;
    }

    @Nonnull
    public String getGranularity() {
        return this._granularity;
    }

    public void setGranularity(@Nonnull String granularity) {
        this._granularity = granularity;
    }

    @Override
    @Nonnull
    public ObjectNode toJsonObject() {
        ObjectNode jsonObject = super.toJsonObject();
        jsonObject.put("format", this._format);
        jsonObject.put("granularity", this._granularity);
        return jsonObject;
    }

    public String toString() {
        return "< field type: DATE_TIME, field name: " + this._name + ", datatype: " + (Object)((Object)this._dataType) + ", time column format: " + this._format + ", time field granularity: " + this._granularity + " >";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        DateTimeFieldSpec that = (DateTimeFieldSpec)o;
        return EqualityUtils.isEqual(this._format, that._format) && EqualityUtils.isEqual(this._granularity, that._granularity);
    }

    @Override
    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(super.hashCode(), this._format);
        result = EqualityUtils.hashCodeOf(result, this._granularity);
        return result;
    }

    public static enum TimeFormat {
        EPOCH,
        SIMPLE_DATE_FORMAT;

    }
}

