/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.data;

import java.util.concurrent.TimeUnit;
import org.apache.pinot.$internal.com.google.common.base.Joiner;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.common.data.DateTimeFieldSpec;
import org.apache.pinot.common.data.DateTimeFormatPatternSpec;
import org.apache.pinot.common.data.DateTimeFormatUnitSpec;
import org.apache.pinot.common.utils.EqualityUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeFormatSpec {
    public static final String FORMAT_TOKENS_ERROR_STR = "format must be of pattern size:timeunit:timeformat(:pattern)";
    public static final String FORMAT_PATTERN_ERROR_STR = "format must be of format [0-9]+:<TimeUnit>:<TimeFormat>(:pattern)";
    public static final String TIME_FORMAT_ERROR_STR = "format must be of format [0-9]+:<TimeUnit>:EPOCH or [0-9]+:<TimeUnit>:SIMPLE_DATE_FORMAT:<format>";
    public static final String NUMBER_REGEX = "[1-9][0-9]*";
    public static final String COLON_SEPARATOR = ":";
    public static final int FORMAT_SIZE_POSITION = 0;
    public static final int FORMAT_UNIT_POSITION = 1;
    public static final int FORMAT_TIMEFORMAT_POSITION = 2;
    public static final int FORMAT_PATTERN_POSITION = 3;
    public static final int MIN_FORMAT_TOKENS = 3;
    public static final int MAX_FORMAT_TOKENS = 4;
    private String _format;
    private int _size;
    private DateTimeFormatUnitSpec _unitSpec;
    private DateTimeFormatPatternSpec _patternSpec;

    public DateTimeFormatSpec(String format) {
        this._format = format;
        if (DateTimeFormatSpec.isValidFormat(format)) {
            String[] formatTokens = format.split(COLON_SEPARATOR, 4);
            this._size = Integer.valueOf(formatTokens[0]);
            this._unitSpec = new DateTimeFormatUnitSpec(formatTokens[1]);
            this._patternSpec = formatTokens.length == 4 ? new DateTimeFormatPatternSpec(formatTokens[2], formatTokens[3]) : new DateTimeFormatPatternSpec(formatTokens[2], null);
        }
    }

    public DateTimeFormatSpec(int columnSize, String columnUnit, String columnTimeFormat) {
        this._format = Joiner.on(COLON_SEPARATOR).join(columnSize, columnUnit, columnTimeFormat);
        DateTimeFormatSpec.isValidFormat(this._format);
        this._size = columnSize;
        this._unitSpec = new DateTimeFormatUnitSpec(columnUnit);
        this._patternSpec = new DateTimeFormatPatternSpec(columnTimeFormat, null);
    }

    public DateTimeFormatSpec(int columnSize, String columnUnit, String columnTimeFormat, String sdfPattern) {
        this._format = Joiner.on(COLON_SEPARATOR).join(columnSize, columnUnit, columnTimeFormat, sdfPattern);
        DateTimeFormatSpec.isValidFormat(this._format);
        this._size = columnSize;
        this._unitSpec = new DateTimeFormatUnitSpec(columnUnit);
        this._patternSpec = new DateTimeFormatPatternSpec(columnTimeFormat, sdfPattern);
    }

    public String getFormat() {
        return this._format;
    }

    public int getColumnSize() {
        return this._size;
    }

    public TimeUnit getColumnUnit() {
        return this._unitSpec.getTimeUnit();
    }

    public DateTimeFormatUnitSpec.DateTimeTransformUnit getColumnDateTimeTransformUnit() {
        return this._unitSpec.getDateTimeTransformUnit();
    }

    public DateTimeFieldSpec.TimeFormat getTimeFormat() {
        return this._patternSpec.getTimeFormat();
    }

    public String getSDFPattern() {
        return this._patternSpec.getSdfPattern();
    }

    public DateTimeZone getDateTimezone() {
        return this._patternSpec.getDateTimeZone();
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this._patternSpec.getDateTimeFormatter();
    }

    public <T> T fromMillisToFormat(Long dateTimeColumnValueMS, Class<T> type) {
        Preconditions.checkNotNull(dateTimeColumnValueMS);
        Object dateTimeColumnValue = null;
        dateTimeColumnValue = this._patternSpec.getTimeFormat().equals((Object)DateTimeFieldSpec.TimeFormat.EPOCH) ? Long.valueOf(this._unitSpec.getTimeUnit().convert(dateTimeColumnValueMS, TimeUnit.MILLISECONDS) / (long)this._size) : this._patternSpec.getDateTimeFormatter().print(dateTimeColumnValueMS.longValue());
        return type.cast(dateTimeColumnValue);
    }

    public Long fromFormatToMillis(Object dateTimeColumnValue) {
        Preconditions.checkNotNull(dateTimeColumnValue);
        Long timeColumnValueMS = 0L;
        timeColumnValueMS = this._patternSpec.getTimeFormat().equals((Object)DateTimeFieldSpec.TimeFormat.EPOCH) ? Long.valueOf(TimeUnit.MILLISECONDS.convert((Long)dateTimeColumnValue * (long)this._size, this._unitSpec.getTimeUnit())) : Long.valueOf(this._patternSpec.getDateTimeFormatter().parseMillis(String.valueOf(dateTimeColumnValue)));
        return timeColumnValueMS;
    }

    public static boolean isValidFormat(String format) {
        Preconditions.checkNotNull(format);
        String[] formatTokens = format.split(COLON_SEPARATOR, 4);
        Preconditions.checkArgument(formatTokens.length == 3 || formatTokens.length == 4, FORMAT_TOKENS_ERROR_STR);
        Preconditions.checkArgument(formatTokens[0].matches(NUMBER_REGEX), FORMAT_PATTERN_ERROR_STR);
        Preconditions.checkArgument(DateTimeFormatUnitSpec.isValidUnitSpec(formatTokens[1]));
        if (formatTokens.length == 3) {
            Preconditions.checkArgument(formatTokens[2].equals(DateTimeFieldSpec.TimeFormat.EPOCH.toString()), TIME_FORMAT_ERROR_STR);
        } else {
            Preconditions.checkArgument(formatTokens[2].equals(DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT.toString()), TIME_FORMAT_ERROR_STR);
        }
        return true;
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        DateTimeFormatSpec that = (DateTimeFormatSpec)o;
        return EqualityUtils.isEqual(this._size, that._size) && EqualityUtils.isEqual(this._format, that._format) && EqualityUtils.isEqual(this._unitSpec, that._unitSpec) && EqualityUtils.isEqual(this._patternSpec, that._patternSpec);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._format);
        result = EqualityUtils.hashCodeOf(result, this._size);
        result = EqualityUtils.hashCodeOf(result, this._unitSpec);
        result = EqualityUtils.hashCodeOf(result, this._patternSpec);
        return result;
    }

    public String toString() {
        return "DateTimeFormatSpec{_format='" + this._format + '\'' + ", _size=" + this._size + ", _unitSpec=" + this._unitSpec + ", _patternSpec=" + this._patternSpec + '}';
    }
}

