/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.utils.EqualityUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class MetricFieldSpec
extends FieldSpec {
    protected static final int UNDEFINED_METRIC_SIZE = -1;
    private int _fieldSize = -1;
    @ConfigKey(value="derivedMetricType")
    private DerivedMetricType _derivedMetricType = null;

    public MetricFieldSpec() {
    }

    public MetricFieldSpec(@Nonnull String name, @Nonnull FieldSpec.DataType dataType) {
        super(name, dataType, true);
        this._fieldSize = this._dataType.size();
    }

    public MetricFieldSpec(@Nonnull String name, @Nonnull FieldSpec.DataType dataType, @Nonnull Object defaultNullValue) {
        super(name, dataType, true, defaultNullValue);
        this._fieldSize = this._dataType.size();
    }

    public MetricFieldSpec(@Nonnull String name, @Nonnull FieldSpec.DataType dataType, int fieldSize, @Nonnull DerivedMetricType derivedMetricType) {
        super(name, dataType, true);
        this.setFieldSize(fieldSize);
        this._derivedMetricType = derivedMetricType;
    }

    public MetricFieldSpec(@Nonnull String name, @Nonnull FieldSpec.DataType dataType, int fieldSize, @Nonnull DerivedMetricType derivedMetricType, @Nonnull Object defaultNullValue) {
        super(name, dataType, true, defaultNullValue);
        this.setFieldSize(fieldSize);
        this._derivedMetricType = derivedMetricType;
    }

    public int getFieldSize() {
        return this._fieldSize;
    }

    public void setFieldSize(int fieldSize) {
        Preconditions.checkArgument(fieldSize > 0, "Field size: " + fieldSize + " is not a positive number.");
        if (this._dataType != null && this._dataType != FieldSpec.DataType.STRING) {
            Preconditions.checkArgument(fieldSize == this._dataType.size(), "Field size: " + fieldSize + " does not match data type: " + (Object)((Object)this._dataType));
        }
        this._fieldSize = fieldSize;
    }

    public DerivedMetricType getDerivedMetricType() {
        return this._derivedMetricType;
    }

    public void setDerivedMetricType(DerivedMetricType derivedMetricType) {
        this._derivedMetricType = derivedMetricType;
    }

    @Override
    @JsonIgnore
    @Nonnull
    public FieldSpec.FieldType getFieldType() {
        return FieldSpec.FieldType.METRIC;
    }

    @Override
    public void setDataType(@Nonnull FieldSpec.DataType dataType) {
        super.setDataType(dataType);
        if (this._dataType != FieldSpec.DataType.STRING && this._dataType != FieldSpec.DataType.BYTES) {
            this._fieldSize = this._dataType.size();
        }
    }

    @Override
    public void setSingleValueField(boolean isSingleValueField) {
        Preconditions.checkArgument(isSingleValueField, "Unsupported multi-value for metric field.");
    }

    @JsonIgnore
    public boolean isDerivedMetric() {
        return this._derivedMetricType != null;
    }

    @Override
    @Nonnull
    public ObjectNode toJsonObject() {
        ObjectNode jsonObject = super.toJsonObject();
        if (this._dataType == FieldSpec.DataType.STRING && this._fieldSize != -1) {
            jsonObject.put("fieldSize", this._fieldSize);
        }
        if (this._derivedMetricType != null) {
            jsonObject.put("derivedMetricType", this._derivedMetricType.name());
        }
        return jsonObject;
    }

    public String toString() {
        return "< field type: METRIC, field name: " + this._name + ", data type: " + (Object)((Object)this._dataType) + ", default null value: " + this._defaultNullValue + ", field size: " + this._fieldSize + ", derived metric type: " + (Object)((Object)this._derivedMetricType) + " >";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        MetricFieldSpec that = (MetricFieldSpec)o;
        return EqualityUtils.isEqual(this._fieldSize, that._fieldSize) && EqualityUtils.isEqual((Object)this._derivedMetricType, (Object)that._derivedMetricType);
    }

    @Override
    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(super.hashCode(), this._fieldSize);
        result = EqualityUtils.hashCodeOf(result, (Object)this._derivedMetricType);
        return result;
    }

    @Override
    public void postInject() {
        super.postInject();
        this._fieldSize = this._dataType.size();
    }

    public static enum DerivedMetricType {
        HLL;

    }
}

