/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.TimeGranularitySpec;
import org.apache.pinot.common.utils.EqualityUtils;
import org.apache.pinot.common.utils.JsonUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class TimeFieldSpec
extends FieldSpec {
    @ConfigKey(value="incoming")
    private TimeGranularitySpec _incomingGranularitySpec;
    @ConfigKey(value="outgoing")
    private TimeGranularitySpec _outgoingGranularitySpec;

    public TimeFieldSpec() {
    }

    public TimeFieldSpec(@Nonnull String incomingName, @Nonnull FieldSpec.DataType incomingDataType, @Nonnull TimeUnit incomingTimeUnit) {
        super(incomingName, incomingDataType, true);
        this._incomingGranularitySpec = new TimeGranularitySpec(incomingDataType, incomingTimeUnit, incomingName);
    }

    public TimeFieldSpec(@Nonnull String incomingName, @Nonnull FieldSpec.DataType incomingDataType, @Nonnull TimeUnit incomingTimeUnit, @Nonnull Object defaultNullValue) {
        super(incomingName, incomingDataType, true, defaultNullValue);
        this._incomingGranularitySpec = new TimeGranularitySpec(incomingDataType, incomingTimeUnit, incomingName);
    }

    public TimeFieldSpec(@Nonnull String incomingName, @Nonnull FieldSpec.DataType incomingDataType, @Nonnull TimeUnit incomingTimeUnit, @Nonnull String outgoingName, @Nonnull FieldSpec.DataType outgoingDataType, @Nonnull TimeUnit outgoingTimeUnit) {
        super(outgoingName, outgoingDataType, true);
        this._incomingGranularitySpec = new TimeGranularitySpec(incomingDataType, incomingTimeUnit, incomingName);
        this._outgoingGranularitySpec = new TimeGranularitySpec(outgoingDataType, outgoingTimeUnit, outgoingName);
    }

    public TimeFieldSpec(@Nonnull String incomingName, @Nonnull FieldSpec.DataType incomingDataType, @Nonnull TimeUnit incomingTimeUnit, @Nonnull String outgoingName, @Nonnull FieldSpec.DataType outgoingDataType, @Nonnull TimeUnit outgoingTimeUnit, @Nonnull Object defaultNullValue) {
        super(outgoingName, outgoingDataType, true, defaultNullValue);
        this._incomingGranularitySpec = new TimeGranularitySpec(incomingDataType, incomingTimeUnit, incomingName);
        this._outgoingGranularitySpec = new TimeGranularitySpec(outgoingDataType, outgoingTimeUnit, outgoingName);
    }

    public TimeFieldSpec(@Nonnull String incomingName, @Nonnull FieldSpec.DataType incomingDataType, int incomingTimeUnitSize, @Nonnull TimeUnit incomingTimeUnit) {
        super(incomingName, incomingDataType, true);
        this._incomingGranularitySpec = new TimeGranularitySpec(incomingDataType, incomingTimeUnitSize, incomingTimeUnit, incomingName);
    }

    public TimeFieldSpec(@Nonnull String incomingName, @Nonnull FieldSpec.DataType incomingDataType, int incomingTimeUnitSize, @Nonnull TimeUnit incomingTimeUnit, @Nonnull Object defaultNullValue) {
        super(incomingName, incomingDataType, true, defaultNullValue);
        this._incomingGranularitySpec = new TimeGranularitySpec(incomingDataType, incomingTimeUnitSize, incomingTimeUnit, incomingName);
    }

    public TimeFieldSpec(@Nonnull String incomingName, @Nonnull FieldSpec.DataType incomingDataType, int incomingTimeUnitSize, @Nonnull TimeUnit incomingTimeUnit, @Nonnull String outgoingName, @Nonnull FieldSpec.DataType outgoingDataType, int outgoingTimeUnitSize, @Nonnull TimeUnit outgoingTimeUnit) {
        super(outgoingName, outgoingDataType, true);
        this._incomingGranularitySpec = new TimeGranularitySpec(incomingDataType, incomingTimeUnitSize, incomingTimeUnit, incomingName);
        this._outgoingGranularitySpec = new TimeGranularitySpec(outgoingDataType, outgoingTimeUnitSize, outgoingTimeUnit, outgoingName);
    }

    public TimeFieldSpec(@Nonnull String incomingName, @Nonnull FieldSpec.DataType incomingDataType, int incomingTimeUnitSize, @Nonnull TimeUnit incomingTimeUnit, @Nonnull String outgoingName, @Nonnull FieldSpec.DataType outgoingDataType, int outgoingTimeUnitSize, @Nonnull TimeUnit outgoingTimeUnit, @Nonnull Object defaultNullValue) {
        super(outgoingName, outgoingDataType, true, defaultNullValue);
        this._incomingGranularitySpec = new TimeGranularitySpec(incomingDataType, incomingTimeUnitSize, incomingTimeUnit, incomingName);
        this._outgoingGranularitySpec = new TimeGranularitySpec(outgoingDataType, outgoingTimeUnitSize, outgoingTimeUnit, outgoingName);
    }

    public TimeFieldSpec(@Nonnull TimeGranularitySpec incomingGranularitySpec) {
        super(incomingGranularitySpec.getName(), incomingGranularitySpec.getDataType(), true);
        this._incomingGranularitySpec = incomingGranularitySpec;
    }

    public TimeFieldSpec(@Nonnull TimeGranularitySpec incomingGranularitySpec, @Nonnull Object defaultNullValue) {
        super(incomingGranularitySpec.getName(), incomingGranularitySpec.getDataType(), true, defaultNullValue);
        this._incomingGranularitySpec = incomingGranularitySpec;
    }

    public TimeFieldSpec(@Nonnull TimeGranularitySpec incomingGranularitySpec, @Nonnull TimeGranularitySpec outgoingGranularitySpec) {
        super(outgoingGranularitySpec.getName(), outgoingGranularitySpec.getDataType(), true);
        this._incomingGranularitySpec = incomingGranularitySpec;
        this._outgoingGranularitySpec = outgoingGranularitySpec;
    }

    public TimeFieldSpec(@Nonnull TimeGranularitySpec incomingGranularitySpec, @Nonnull TimeGranularitySpec outgoingGranularitySpec, @Nonnull Object defaultNullValue) {
        super(outgoingGranularitySpec.getName(), outgoingGranularitySpec.getDataType(), true, defaultNullValue);
        this._incomingGranularitySpec = incomingGranularitySpec;
        this._outgoingGranularitySpec = outgoingGranularitySpec;
    }

    @Override
    @JsonIgnore
    @Nonnull
    public FieldSpec.FieldType getFieldType() {
        return FieldSpec.FieldType.TIME;
    }

    @Override
    public void setName(@Nonnull String name) {
    }

    @Override
    public void setDataType(@Nonnull FieldSpec.DataType dataType) {
    }

    @Override
    public void setSingleValueField(boolean isSingleValueField) {
        Preconditions.checkArgument(isSingleValueField, "Unsupported multi-value for time field.");
    }

    @JsonIgnore
    @Nonnull
    public String getIncomingTimeColumnName() {
        return this._incomingGranularitySpec.getName();
    }

    @JsonIgnore
    @Nonnull
    public String getOutgoingTimeColumnName() {
        return this.getName();
    }

    @Deprecated
    @JsonIgnore
    @Nonnull
    public String getOutGoingTimeColumnName() {
        return this.getName();
    }

    @Nonnull
    public TimeGranularitySpec getIncomingGranularitySpec() {
        return this._incomingGranularitySpec;
    }

    public void setIncomingGranularitySpec(@Nonnull TimeGranularitySpec incomingGranularitySpec) {
        this._incomingGranularitySpec = incomingGranularitySpec;
        if (this._outgoingGranularitySpec == null) {
            super.setName(incomingGranularitySpec.getName());
            super.setDataType(incomingGranularitySpec.getDataType());
        }
    }

    @Nonnull
    public TimeGranularitySpec getOutgoingGranularitySpec() {
        if (this._outgoingGranularitySpec == null) {
            return this._incomingGranularitySpec;
        }
        return this._outgoingGranularitySpec;
    }

    public void setOutgoingGranularitySpec(@Nonnull TimeGranularitySpec outgoingGranularitySpec) {
        this._outgoingGranularitySpec = outgoingGranularitySpec;
        super.setName(outgoingGranularitySpec.getName());
        super.setDataType(outgoingGranularitySpec.getDataType());
    }

    @Override
    @Nonnull
    public ObjectNode toJsonObject() {
        ObjectNode jsonObject = JsonUtils.newObjectNode();
        jsonObject.set("incomingGranularitySpec", (JsonNode)this._incomingGranularitySpec.toJsonObject());
        if (!this.getOutgoingGranularitySpec().equals(this._incomingGranularitySpec)) {
            jsonObject.set("outgoingGranularitySpec", (JsonNode)this._outgoingGranularitySpec.toJsonObject());
        }
        this.appendDefaultNullValue(jsonObject);
        return jsonObject;
    }

    public String toString() {
        return "< field type: TIME, incoming granularity spec: " + this._incomingGranularitySpec + ", outgoing granularity spec: " + this.getOutgoingGranularitySpec() + ", default null value: " + this._defaultNullValue + " >";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TimeFieldSpec that = (TimeFieldSpec)o;
        return EqualityUtils.isEqual(this._incomingGranularitySpec, that._incomingGranularitySpec) && EqualityUtils.isEqual(this.getOutgoingGranularitySpec(), that.getOutgoingGranularitySpec());
    }

    @Override
    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(super.hashCode(), this._incomingGranularitySpec);
        result = EqualityUtils.hashCodeOf(result, this.getOutgoingGranularitySpec());
        return result;
    }
}

