/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.utils.EqualityUtils;
import org.apache.pinot.common.utils.JsonUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TimeGranularitySpec {
    private static final int DEFAULT_TIME_UNIT_SIZE = 1;
    private static final String DEFAULT_TIME_FORMAT = TimeFormat.EPOCH.toString();
    private static final String COLON_SEPARATOR = ":";
    @ConfigKey(value="name")
    private String _name;
    @ConfigKey(value="dataType")
    private FieldSpec.DataType _dataType;
    @ConfigKey(value="timeType")
    private TimeUnit _timeType;
    @ConfigKey(value="timeUnitSize")
    private int _timeUnitSize = 1;
    @ConfigKey(value="timeFormat")
    private String _timeFormat = DEFAULT_TIME_FORMAT;

    public TimeGranularitySpec() {
    }

    public TimeGranularitySpec(@Nonnull FieldSpec.DataType dataType, @Nonnull TimeUnit timeType, @Nonnull String name) {
        Preconditions.checkNotNull(timeType);
        Preconditions.checkNotNull(name);
        this._dataType = dataType.getStoredType();
        this._timeType = timeType;
        this._name = name;
    }

    public TimeGranularitySpec(@Nonnull FieldSpec.DataType dataType, @Nonnull TimeUnit timeType, @Nonnull String timeFormat, @Nonnull String name) {
        Preconditions.checkNotNull(timeType);
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(timeFormat);
        Preconditions.checkArgument(timeFormat.equals(TimeFormat.EPOCH.toString()) || timeFormat.startsWith(TimeFormat.SIMPLE_DATE_FORMAT.toString()));
        this._dataType = dataType.getStoredType();
        this._timeType = timeType;
        this._name = name;
        this._timeFormat = timeFormat;
    }

    public TimeGranularitySpec(@Nonnull FieldSpec.DataType dataType, int timeUnitSize, @Nonnull TimeUnit timeType, @Nonnull String name) {
        Preconditions.checkNotNull(timeType);
        Preconditions.checkNotNull(name);
        this._dataType = dataType.getStoredType();
        this._timeType = timeType;
        this._timeUnitSize = timeUnitSize;
        this._name = name;
    }

    public TimeGranularitySpec(@Nonnull FieldSpec.DataType dataType, int timeUnitSize, @Nonnull TimeUnit timeType, @Nonnull String timeFormat, @Nonnull String name) {
        Preconditions.checkNotNull(timeType);
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(timeFormat);
        Preconditions.checkArgument(timeFormat.equals(TimeFormat.EPOCH.toString()) || timeFormat.startsWith(TimeFormat.SIMPLE_DATE_FORMAT.toString()));
        this._dataType = dataType.getStoredType();
        this._timeType = timeType;
        this._timeUnitSize = timeUnitSize;
        this._name = name;
        this._timeFormat = timeFormat;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    public void setName(@Nonnull String name) {
        this._name = name;
    }

    @Nonnull
    public FieldSpec.DataType getDataType() {
        return this._dataType;
    }

    public void setDataType(@Nonnull FieldSpec.DataType dataType) {
        this._dataType = dataType.getStoredType();
    }

    @Nonnull
    public TimeUnit getTimeType() {
        return this._timeType;
    }

    public void setTimeType(@Nonnull TimeUnit timeType) {
        this._timeType = timeType;
    }

    public int getTimeUnitSize() {
        return this._timeUnitSize;
    }

    public void setTimeUnitSize(int timeUnitSize) {
        Preconditions.checkArgument(timeUnitSize > 0);
        this._timeUnitSize = timeUnitSize;
    }

    public void setTimeunitSize(int timeUnitSize) {
        Preconditions.checkArgument(timeUnitSize > 0);
        this._timeUnitSize = timeUnitSize;
    }

    @Nonnull
    public String getTimeFormat() {
        return this._timeFormat;
    }

    public void setTimeFormat(@Nonnull String timeFormat) {
        this._timeFormat = timeFormat;
    }

    public DateTime toDateTime(long timeSinceEpoch) {
        return new DateTime(this._timeType.toMillis(timeSinceEpoch * (long)this._timeUnitSize));
    }

    public Long toMillis(Object timeColumnValue) {
        Long timeColumnValueMs;
        Preconditions.checkNotNull(timeColumnValue);
        if (this._timeFormat.equals(TimeFormat.EPOCH.toString())) {
            timeColumnValueMs = TimeUnit.MILLISECONDS.convert((Long)timeColumnValue * (long)this._timeUnitSize, this._timeType);
        } else {
            String pattern = this._timeFormat.split(COLON_SEPARATOR)[1];
            timeColumnValueMs = DateTimeFormat.forPattern((String)pattern).parseMillis(String.valueOf(timeColumnValue));
        }
        return timeColumnValueMs;
    }

    public Object fromMillis(Long timeColumnValueMS) {
        Object timeColumnValue;
        Preconditions.checkNotNull(timeColumnValueMS);
        if (this._timeFormat.equals(TimeFormat.EPOCH.toString())) {
            timeColumnValue = this._timeType.convert(timeColumnValueMS, TimeUnit.MILLISECONDS) / (long)this._timeUnitSize;
        } else {
            String pattern = this._timeFormat.split(COLON_SEPARATOR)[1];
            timeColumnValue = DateTimeFormat.forPattern((String)pattern).print(timeColumnValueMS.longValue());
        }
        return timeColumnValue;
    }

    public ObjectNode toJsonObject() {
        ObjectNode jsonObject = JsonUtils.newObjectNode();
        jsonObject.put("name", this._name);
        jsonObject.put("dataType", this._dataType.name());
        jsonObject.put("timeType", this._timeType.name());
        if (this._timeUnitSize != 1) {
            jsonObject.put("timeUnitSize", this._timeUnitSize);
        }
        if (!this._timeFormat.equals(DEFAULT_TIME_FORMAT)) {
            jsonObject.put("timeFormat", this._timeFormat);
        }
        return jsonObject;
    }

    public String toString() {
        return "< field name: " + this._name + ", data type: " + (Object)((Object)this._dataType) + ", time type: " + (Object)((Object)this._timeType) + ", time unit size: " + this._timeUnitSize + ", time format: " + this._timeFormat + " >";
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        TimeGranularitySpec that = (TimeGranularitySpec)o;
        return EqualityUtils.isEqual(this._name, that._name) && EqualityUtils.isEqual((Object)this._dataType, (Object)that._dataType) && EqualityUtils.isEqual((Object)this._timeType, (Object)that._timeType) && EqualityUtils.isEqual(this._timeUnitSize, that._timeUnitSize) && EqualityUtils.isEqual(this._timeFormat, that._timeFormat);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._name);
        result = EqualityUtils.hashCodeOf(result, (Object)this._dataType);
        result = EqualityUtils.hashCodeOf(result, (Object)this._timeType);
        result = EqualityUtils.hashCodeOf(result, this._timeUnitSize);
        result = EqualityUtils.hashCodeOf(result, this._timeFormat);
        return result;
    }

    public static enum TimeFormat {
        EPOCH,
        SIMPLE_DATE_FORMAT;

    }
}

