/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.lineage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.helix.ZNRecord;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.lineage.SegmentGroup;
import org.apache.pinot.common.utils.EqualityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMergeLineage {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentMergeLineage.class);
    private static final String LEVEL_KEY_PREFIX = "level_";
    private static final String ROOT_NODE_GROUP_ID = "root";
    private static final String SEGMENT_DELIMITER = ",";
    private static final int DEFAULT_GROUP_LEVEL = 0;
    private String _tableNameWithType;
    private Map<String, List<String>> _parentGroupToChildrenGroupsMap;
    private Map<Integer, Map<String, List<String>>> _levelToGroupToSegmentsMap;

    public SegmentMergeLineage(String tableNameWithType) {
        this._tableNameWithType = tableNameWithType;
        this._parentGroupToChildrenGroupsMap = new HashMap<String, List<String>>();
        this._levelToGroupToSegmentsMap = new HashMap<Integer, Map<String, List<String>>>();
    }

    public SegmentMergeLineage(String tableNameWithType, Map<String, List<String>> segmentGroupLineageMap, Map<Integer, Map<String, List<String>>> levelToGroupToSegmentMap) {
        this._tableNameWithType = tableNameWithType;
        this._parentGroupToChildrenGroupsMap = segmentGroupLineageMap;
        this._levelToGroupToSegmentsMap = levelToGroupToSegmentMap;
    }

    public String getTableName() {
        return this._tableNameWithType;
    }

    public static SegmentMergeLineage fromZNRecord(ZNRecord record) {
        String tableNameWithType = record.getId();
        Map segmentGroupLineageMap = record.getListFields();
        HashMap<Integer, Map<String, List<String>>> groupToSegmentsMap = new HashMap<Integer, Map<String, List<String>>>();
        for (Map.Entry entry : record.getMapFields().entrySet()) {
            String levelKey = (String)entry.getKey();
            Integer level = Integer.parseInt(levelKey.substring(LEVEL_KEY_PREFIX.length()));
            HashMap<String, ArrayList<String>> groupToSegmentsForLevel = new HashMap<String, ArrayList<String>>();
            for (Map.Entry groupEntry : ((Map)entry.getValue()).entrySet()) {
                String groupId = (String)groupEntry.getKey();
                String segmentsString = (String)groupEntry.getValue();
                List<String> segments = Arrays.asList(segmentsString.split(SEGMENT_DELIMITER));
                groupToSegmentsForLevel.put(groupId, new ArrayList<String>(segments));
            }
            groupToSegmentsMap.put(level, groupToSegmentsForLevel);
        }
        return new SegmentMergeLineage(tableNameWithType, segmentGroupLineageMap, groupToSegmentsMap);
    }

    public ZNRecord toZNRecord() {
        ZNRecord record = new ZNRecord(this._tableNameWithType);
        record.setListFields(this._parentGroupToChildrenGroupsMap);
        HashMap groupToSegmentsMap = new HashMap();
        for (Map.Entry<Integer, Map<String, List<String>>> entry : this._levelToGroupToSegmentsMap.entrySet()) {
            String key = LEVEL_KEY_PREFIX + entry.getKey();
            HashMap<String, String> groupSegmentsForLevel = new HashMap<String, String>();
            for (Map.Entry<String, List<String>> groupEntry : entry.getValue().entrySet()) {
                String groupId = groupEntry.getKey();
                String segments = String.join((CharSequence)SEGMENT_DELIMITER, (Iterable<? extends CharSequence>)groupEntry.getValue());
                groupSegmentsForLevel.put(groupId, segments);
            }
            groupToSegmentsMap.put(key, groupSegmentsForLevel);
        }
        record.setMapFields(groupToSegmentsMap);
        return record;
    }

    public void addSegmentGroup(String groupId, List<String> currentGroupSegments, List<String> childrenGroups) throws InvalidConfigException {
        Integer groupLevel = this.getGroupLevel(childrenGroups);
        Map groupToSegmentMap = this._levelToGroupToSegmentsMap.computeIfAbsent(groupLevel, k -> new HashMap());
        if (groupToSegmentMap.containsKey(groupId) || this._parentGroupToChildrenGroupsMap.containsKey(groupId)) {
            throw new InvalidConfigException("Group id : " + groupId + " already exists for table " + this._tableNameWithType);
        }
        groupToSegmentMap.put(groupId, new ArrayList<String>(currentGroupSegments));
        this._levelToGroupToSegmentsMap.put(groupLevel, groupToSegmentMap);
        if (groupLevel > 0) {
            this._parentGroupToChildrenGroupsMap.put(groupId, new ArrayList<String>(childrenGroups));
        }
        LOGGER.info("New group has been added successfully to the segment lineage. (tableName: {}, groupId: {}, currentGroupSegments: {}, childrenGroups: {}", new Object[]{this._tableNameWithType, groupId, currentGroupSegments, childrenGroups});
    }

    public void removeSegmentGroup(String groupId) {
        this._parentGroupToChildrenGroupsMap.remove(groupId);
        for (List<String> list : this._parentGroupToChildrenGroupsMap.values()) {
            list.remove(groupId);
        }
        for (Map map : this._levelToGroupToSegmentsMap.values()) {
            map.remove(groupId);
        }
        LOGGER.info("Group {} has been successfully removed for table {}.", (Object)groupId, (Object)this._tableNameWithType);
    }

    public SegmentGroup getMergeLineageRootSegmentGroup() {
        HashMap<String, SegmentGroup> groupNodes = new HashMap<String, SegmentGroup>();
        for (Map.Entry<Integer, Map<String, List<String>>> entry : this._levelToGroupToSegmentsMap.entrySet()) {
            Integer level = entry.getKey();
            Map<String, List<String>> groupToSegmentsForLevel = entry.getValue();
            for (Map.Entry<String, List<String>> entry2 : groupToSegmentsForLevel.entrySet()) {
                String groupId = entry2.getKey();
                List<String> segments = entry2.getValue();
                SegmentGroup groupNode = new SegmentGroup();
                groupNode.setGroupId(groupId);
                groupNode.setSegments(new HashSet<String>(segments));
                groupNode.setGroupLevel(level);
                groupNodes.put(groupId, groupNode);
            }
        }
        for (Map.Entry<Object, Object> entry : this._parentGroupToChildrenGroupsMap.entrySet()) {
            String parentGroupId = (String)entry.getKey();
            List childrenGroupIds = (List)entry.getValue();
            ArrayList<SegmentGroup> childrenGroups = new ArrayList<SegmentGroup>();
            SegmentGroup parentNode = (SegmentGroup)groupNodes.get(parentGroupId);
            for (String groupId : childrenGroupIds) {
                SegmentGroup childNode = (SegmentGroup)groupNodes.get(groupId);
                if (childNode == null) continue;
                childrenGroups.add(childNode);
                childNode.setParentGroup(parentNode);
            }
            parentNode.setChildrenGroups(childrenGroups);
        }
        SegmentGroup root = new SegmentGroup();
        root.setGroupId(ROOT_NODE_GROUP_ID);
        ArrayList<SegmentGroup> arrayList = new ArrayList<SegmentGroup>();
        for (SegmentGroup group : groupNodes.values()) {
            if (group.getParentGroup() != null) continue;
            group.setParentGroup(root);
            arrayList.add(group);
        }
        root.setChildrenGroups(arrayList);
        return root;
    }

    public List<String> getSegmentsForGroup(String groupId) {
        for (Map<String, List<String>> groupToSegmentMap : this._levelToGroupToSegmentsMap.values()) {
            List<String> segments = groupToSegmentMap.get(groupId);
            if (segments == null) continue;
            return segments;
        }
        return null;
    }

    public List<String> getChildrenForGroup(String groupId) {
        return this._parentGroupToChildrenGroupsMap.get(groupId);
    }

    public List<Integer> getAllGroupLevels() {
        ArrayList<Integer> groupLevels = new ArrayList<Integer>(this._levelToGroupToSegmentsMap.keySet());
        Collections.sort(groupLevels);
        return groupLevels;
    }

    public List<String> getGroupIdsForGroupLevel(int groupLevel) {
        Map<String, List<String>> groupToSegmentsMap = this._levelToGroupToSegmentsMap.get(groupLevel);
        if (groupToSegmentsMap != null) {
            return new ArrayList<String>(groupToSegmentsMap.keySet());
        }
        return null;
    }

    private Integer getGroupLevel(List<String> childrenGroups) throws InvalidConfigException {
        if (childrenGroups == null || childrenGroups.isEmpty()) {
            return 0;
        }
        for (Map.Entry<Integer, Map<String, List<String>>> entry : this._levelToGroupToSegmentsMap.entrySet()) {
            Integer currentLevel = entry.getKey();
            Map<String, List<String>> currentLevelGroupToSegmentsMap = entry.getValue();
            if (!currentLevelGroupToSegmentsMap.keySet().containsAll(childrenGroups)) continue;
            return currentLevel + 1;
        }
        throw new InvalidConfigException("Cannot compute group level because not all children groups exist in the segment merge lineage, table name: " + this._tableNameWithType + ", children groups: " + childrenGroups + "table");
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        SegmentMergeLineage that = (SegmentMergeLineage)o;
        return EqualityUtils.isEqual(this._tableNameWithType, that._tableNameWithType) && EqualityUtils.isEqual(this._parentGroupToChildrenGroupsMap, that._parentGroupToChildrenGroupsMap) && EqualityUtils.isEqual(this._levelToGroupToSegmentsMap, that._levelToGroupToSegmentsMap);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._tableNameWithType);
        result = EqualityUtils.hashCodeOf(result, this._parentGroupToChildrenGroupsMap);
        result = EqualityUtils.hashCodeOf(result, this._levelToGroupToSegmentsMap);
        return result;
    }
}

