/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.lineage;

import org.apache.helix.AccessOption;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.lineage.SegmentMergeLineage;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.zookeeper.data.Stat;

public class SegmentMergeLineageAccessHelper {
    public static ZNRecord getSegmentMergeLineageZNRecord(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType) {
        Stat stat;
        String path = ZKMetadataProvider.constructPropertyStorePathForSegmentMergeLineage(tableNameWithType);
        ZNRecord segmentMergeLineageZNRecord = (ZNRecord)propertyStore.get(path, stat = new Stat(), AccessOption.PERSISTENT);
        if (segmentMergeLineageZNRecord != null) {
            segmentMergeLineageZNRecord.setVersion(stat.getVersion());
        }
        return segmentMergeLineageZNRecord;
    }

    public static SegmentMergeLineage getSegmentMergeLineage(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType) {
        ZNRecord znRecord = SegmentMergeLineageAccessHelper.getSegmentMergeLineageZNRecord(propertyStore, tableNameWithType);
        SegmentMergeLineage segmentMergeLineage = null;
        if (znRecord != null) {
            segmentMergeLineage = SegmentMergeLineage.fromZNRecord(znRecord);
        }
        return segmentMergeLineage;
    }

    public static boolean writeSegmentMergeLineage(ZkHelixPropertyStore<ZNRecord> propertyStore, SegmentMergeLineage segmentMergeLineage, int expectedVersion) {
        String tableNameWithType = segmentMergeLineage.getTableName();
        String path = ZKMetadataProvider.constructPropertyStorePathForSegmentMergeLineage(tableNameWithType);
        return propertyStore.set(path, (Object)segmentMergeLineage.toZNRecord(), expectedVersion, AccessOption.PERSISTENT);
    }
}

