/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.messages;

import java.util.UUID;
import org.apache.helix.model.Message;

public class SegmentRefreshMessage
extends Message {
    public static final String REFRESH_SEGMENT_MSG_SUB_TYPE = "REFRESH_SEGMENT";
    private static final String SIMPLE_FIELD_CRC = "PINOT_SEGMENT_CRC";

    public SegmentRefreshMessage(String tableName, String segmentName, long crc) {
        super(Message.MessageType.USER_DEFINE_MSG, UUID.randomUUID().toString());
        this.setResourceName(tableName);
        this.setPartitionName(segmentName);
        this.setMsgSubType(REFRESH_SEGMENT_MSG_SUB_TYPE);
        this.setExecutionTimeout(-1);
        this.getRecord().setSimpleField(SIMPLE_FIELD_CRC, Long.toString(crc));
    }

    public SegmentRefreshMessage(Message message) {
        super(message.getRecord());
        if (!message.getMsgSubType().equals(REFRESH_SEGMENT_MSG_SUB_TYPE)) {
            throw new IllegalArgumentException("Invalid message subtype:" + message.getMsgSubType());
        }
    }

    public long getCrc() {
        return Long.valueOf(this.getRecord().getSimpleField(SIMPLE_FIELD_CRC));
    }
}

