/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.messages;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.helix.model.Message;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;

public class SegmentReloadMessage
extends Message {
    public static final String RELOAD_SEGMENT_MSG_SUB_TYPE = "RELOAD_SEGMENT";

    public SegmentReloadMessage(@Nonnull String tableNameWithType, @Nullable String segmentName) {
        super(Message.MessageType.USER_DEFINE_MSG, UUID.randomUUID().toString());
        this.setResourceName(tableNameWithType);
        if (segmentName != null) {
            this.setPartitionName(segmentName);
        }
        this.setMsgSubType(RELOAD_SEGMENT_MSG_SUB_TYPE);
        this.setExecutionTimeout(-1);
    }

    public SegmentReloadMessage(Message message) {
        super(message.getRecord());
        String msgSubType = message.getMsgSubType();
        Preconditions.checkArgument(msgSubType.equals(RELOAD_SEGMENT_MSG_SUB_TYPE), "Invalid message sub type: " + msgSubType + " for SegmentReloadMessage");
    }
}

