/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.messages;

import java.util.UUID;
import org.apache.helix.model.Message;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;

public class TimeboundaryRefreshMessage
extends Message {
    public static final String REFRESH_TIME_BOUNDARY_MSG_SUB_TYPE = "REFRESH_TIME_BOUNDARY";

    public TimeboundaryRefreshMessage(String tableName, String segmentName) {
        super(Message.MessageType.USER_DEFINE_MSG, UUID.randomUUID().toString());
        this.setResourceName(tableName);
        this.setPartitionName(segmentName);
        this.setMsgSubType(REFRESH_TIME_BOUNDARY_MSG_SUB_TYPE);
        this.setExecutionTimeout(-1);
    }

    public TimeboundaryRefreshMessage(Message message) {
        super(message.getRecord());
        String msgSubType = message.getMsgSubType();
        Preconditions.checkArgument(msgSubType.equals(REFRESH_TIME_BOUNDARY_MSG_SUB_TYPE), "Invalid message sub type: " + msgSubType + " for TimeboundaryRefreshMessage");
    }
}

