/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.pinot.$internal.com.yammer.metrics.core.Histogram;
import org.apache.pinot.$internal.com.yammer.metrics.core.Metric;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricName;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricProcessor;
import org.apache.pinot.$internal.com.yammer.metrics.core.Sampling;
import org.apache.pinot.$internal.com.yammer.metrics.core.Summarizable;
import org.apache.pinot.$internal.com.yammer.metrics.stats.Snapshot;

public class AggregatedHistogram<T extends Sampling>
implements Sampling,
Summarizable,
Metric {
    private final List<T> _histograms = new CopyOnWriteArrayList<T>();
    private static final long DEFAULT_REFRESH_MS = 60000L;
    private final long _refreshMs;
    private volatile long _lastRefreshedTime;
    private volatile double _max;
    private volatile double _min;
    private volatile double _mean;
    private volatile double _stdDev;
    private volatile double _sum;
    private volatile Snapshot _snapshot;

    public AggregatedHistogram(long refreshMs) {
        this._refreshMs = refreshMs;
    }

    public AggregatedHistogram() {
        this._refreshMs = 60000L;
    }

    public AggregatedHistogram<T> addAll(Collection<T> histograms) {
        this._histograms.addAll(histograms);
        return this;
    }

    public AggregatedHistogram<T> add(T histogram) {
        this._histograms.add(histogram);
        return this;
    }

    public boolean remove(T histogram) {
        return this._histograms.remove(histogram);
    }

    private void refreshIfElapsed() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this._lastRefreshedTime > this._refreshMs && !this._histograms.isEmpty()) {
            this.refresh();
            this._lastRefreshedTime = currentTime;
        }
    }

    public void refresh() {
        ArrayList<Double> values = new ArrayList<Double>();
        this._min = Double.MAX_VALUE;
        this._max = Double.MIN_VALUE;
        this._sum = 0.0;
        double meanSum = 0.0;
        for (Sampling hist : this._histograms) {
            double[] val;
            Metric h;
            if (hist instanceof Histogram) {
                h = (Histogram)hist;
                this._min = Math.min(this._min, ((Histogram)h).min());
                this._max = Math.max(this._max, ((Histogram)h).max());
                this._sum += ((Histogram)h).sum();
                meanSum += ((Histogram)h).mean();
            } else {
                h = (AggregatedHistogram)hist;
                this._min = Math.min(this._min, ((AggregatedHistogram)h).min());
                this._max = Math.max(this._max, ((AggregatedHistogram)h).max());
                this._sum += ((AggregatedHistogram)h).sum();
                meanSum += ((AggregatedHistogram)h).mean();
            }
            for (double d : val = hist.getSnapshot().getValues()) {
                values.add(d);
            }
        }
        if (!this._histograms.isEmpty()) {
            this._mean = meanSum / (double)this._histograms.size();
        }
        if (!values.isEmpty()) {
            double[] vals = new double[values.size()];
            int i = 0;
            for (Double d : values) {
                vals[i++] = d;
            }
            this._snapshot = new Snapshot(vals);
        }
    }

    @Override
    public double max() {
        this.refreshIfElapsed();
        return this._max;
    }

    @Override
    public double min() {
        this.refreshIfElapsed();
        return this._min;
    }

    @Override
    public double mean() {
        this.refreshIfElapsed();
        return this._mean;
    }

    @Override
    public double stdDev() {
        this.refreshIfElapsed();
        return this._stdDev;
    }

    @Override
    public double sum() {
        this.refreshIfElapsed();
        return this._sum;
    }

    @Override
    public Snapshot getSnapshot() {
        this.refreshIfElapsed();
        return this._snapshot;
    }

    public <T2> void processWith(MetricProcessor<T2> processor, MetricName name, T2 context) throws Exception {
        for (Sampling h : this._histograms) {
            if (!(h instanceof Metric)) continue;
            ((Metric)((Object)h)).processWith(processor, name, context);
        }
    }
}

