/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import org.apache.pinot.$internal.com.yammer.metrics.core.Sampling;
import org.apache.pinot.$internal.com.yammer.metrics.core.Summarizable;
import org.apache.pinot.$internal.com.yammer.metrics.stats.Snapshot;

public class LatencyMetric<T extends Sampling & Summarizable> {
    private final double _mean;
    private final double _min;
    private final double _max;
    private final double _percentile95;
    private final double _percentile99;
    private final double _percentile999;
    private final T _histogram;

    public LatencyMetric(T h) {
        Snapshot s = h.getSnapshot();
        this._min = ((Summarizable)h).min();
        this._max = ((Summarizable)h).max();
        this._mean = ((Summarizable)h).mean();
        if (null != s) {
            this._percentile95 = s.get95thPercentile();
            this._percentile99 = s.get99thPercentile();
            this._percentile999 = s.get999thPercentile();
        } else {
            this._percentile95 = -1.0;
            this._percentile99 = -1.0;
            this._percentile999 = -1.0;
        }
        this._histogram = h;
    }

    public double getMean() {
        return this._mean;
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    public double getPercentile95() {
        return this._percentile95;
    }

    public double getPercentile99() {
        return this._percentile99;
    }

    public double getPercentile999() {
        return this._percentile999;
    }

    public T getHistogram() {
        return this._histogram;
    }

    public String toString() {
        return "LatencyMetric [_mean=" + this._mean + ", _min=" + this._min + ", _max=" + this._max + ", _percentile95=" + this._percentile95 + ", _percentile99=" + this._percentile99 + ", _percentile999=" + this._percentile999 + ", _histogram=" + this._histogram + "]";
    }
}

