/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metrics.AbstractMetrics;

public enum ServerMeter implements AbstractMetrics.Meter
{
    QUERIES("queries", true),
    UNCAUGHT_EXCEPTIONS("exceptions", true),
    REQUEST_DESERIALIZATION_EXCEPTIONS("exceptions", true),
    RESPONSE_SERIALIZATION_EXCEPTIONS("exceptions", true),
    SCHEDULING_TIMEOUT_EXCEPTIONS("exceptions", true),
    QUERY_EXECUTION_EXCEPTIONS("exceptions", false),
    HELIX_ZOOKEEPER_RECONNECTS("reconnects", true),
    DELETED_SEGMENT_COUNT("segments", false),
    REALTIME_ROWS_CONSUMED("rows", true),
    INVALID_REALTIME_ROWS_DROPPED("rows", false),
    REALTIME_CONSUMPTION_EXCEPTIONS("exceptions", true),
    REALTIME_OFFSET_COMMITS("commits", true),
    REALTIME_OFFSET_COMMIT_EXCEPTIONS("exceptions", false),
    ROWS_WITH_ERRORS("rows", false),
    LLC_CONTROLLER_RESPONSE_NOT_SENT("messages", true),
    LLC_CONTROLLER_RESPONSE_COMMIT("messages", true),
    LLC_CONTROLLER_RESPONSE_HOLD("messages", true),
    LLC_CONTROLLER_RESPONSE_CATCH_UP("messages", true),
    LLC_CONTROLLER_RESPONSE_DISCARD("messages", true),
    LLC_CONTROLLER_RESPONSE_KEEP("messages", true),
    LLC_CONTROLLER_RESPONSE_NOT_LEADER("messages", true),
    LLC_CONTROLLER_RESPONSE_FAILED("messages", true),
    LLC_CONTROLLER_RESPONSE_COMMIT_SUCCESS("messages", true),
    LLC_CONTROLLER_RESPONSE_COMMIT_CONTINUE("messages", true),
    LLC_CONTROLLER_RESPONSE_PROCESSED("messages", true),
    LLC_CONTROLLER_RESPONSE_UPLOAD_SUCCESS("messages", true),
    NUM_DOCS_SCANNED("rows", false),
    NUM_ENTRIES_SCANNED_IN_FILTER("entries", false),
    NUM_ENTRIES_SCANNED_POST_FILTER("entries", false),
    NUM_SEGMENTS_QUERIED("numSegmentsQueried", false),
    NUM_SEGMENTS_PROCESSED("numSegmentsProcessed", false),
    NUM_SEGMENTS_MATCHED("numSegmentsMatched", false),
    NUM_MISSING_SEGMENTS("segments", false),
    RELOAD_FAILURES("segments", false),
    REFRESH_FAILURES("segments", false);

    private final String meterName;
    private final String unit;
    private final boolean global;

    private ServerMeter(String unit, boolean global) {
        this.unit = unit;
        this.global = global;
        this.meterName = Utils.toCamelCase(this.name().toLowerCase());
    }

    @Override
    public String getMeterName() {
        return this.meterName;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public boolean isGlobal() {
        return this.global;
    }
}

