/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.$internal.com.yammer.metrics.core.Gauge;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricName;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricsRegistry;
import org.apache.pinot.common.metrics.MetricsHelper;

public class ValidationMetrics {
    private final MetricsRegistry _metricsRegistry;
    private final Map<String, Long> _gaugeValues = new HashMap<String, Long>();
    private final Set<MetricName> _metricNames = new HashSet<MetricName>();
    private final StoredValueGaugeFactory _storedValueGaugeFactory = new StoredValueGaugeFactory();
    private final CurrentTimeMillisDeltaGaugeFactory _currentTimeMillisDeltaGaugeFactory = new CurrentTimeMillisDeltaGaugeFactory();
    private final CurrentTimeMillisDeltaGaugeHoursFactory _currentTimeMillisDeltaGaugeHoursFactory = new CurrentTimeMillisDeltaGaugeHoursFactory();

    public ValidationMetrics(MetricsRegistry metricsRegistry) {
        this._metricsRegistry = metricsRegistry;
    }

    public void updateMissingSegmentCountGauge(String resource, int missingSegmentCount) {
        String fullGaugeName = this.makeGaugeName(resource, "missingSegmentCount");
        this.makeGauge(fullGaugeName, this.makeMetricName(fullGaugeName), this._storedValueGaugeFactory, missingSegmentCount);
    }

    public void updateOfflineSegmentDelayGauge(String resource, long lastOfflineSegmentTime) {
        String fullGaugeName = this.makeGaugeName(resource, "offlineSegmentDelayMillis");
        this.makeGauge(fullGaugeName, this.makeMetricName(fullGaugeName), this._currentTimeMillisDeltaGaugeFactory, lastOfflineSegmentTime);
        String fullGaugeNameHours = this.makeGaugeName(resource, "offlineSegmentDelayHours");
        this.makeGauge(fullGaugeNameHours, this.makeMetricName(fullGaugeNameHours), this._currentTimeMillisDeltaGaugeHoursFactory, lastOfflineSegmentTime);
    }

    public void updateLastPushTimeGauge(String resource, long lastPushTimeMillis) {
        String fullGaugeName = this.makeGaugeName(resource, "lastPushTimeDelayMillis");
        this.makeGauge(fullGaugeName, this.makeMetricName(fullGaugeName), this._currentTimeMillisDeltaGaugeFactory, lastPushTimeMillis);
        String fullGaugeNameHours = this.makeGaugeName(resource, "lastPushTimeDelayHours");
        this.makeGauge(fullGaugeNameHours, this.makeMetricName(fullGaugeNameHours), this._currentTimeMillisDeltaGaugeHoursFactory, lastPushTimeMillis);
    }

    public void updateTotalDocumentCountGauge(String resource, long documentCount) {
        String fullGaugeName = this.makeGaugeName(resource, "TotalDocumentCount");
        this.makeGauge(fullGaugeName, this.makeMetricName(fullGaugeName), this._storedValueGaugeFactory, documentCount);
    }

    public void updateNonConsumingPartitionCountMetric(String resource, int partitionCount) {
        String fullGaugeName = this.makeGaugeName(resource, "NonConsumingPartitionCount");
        this.makeGauge(fullGaugeName, this.makeMetricName(fullGaugeName), this._storedValueGaugeFactory, partitionCount);
    }

    public void updateSegmentCountGauge(String resource, long segmentCount) {
        String fullGaugeName = this.makeGaugeName(resource, "SegmentCount");
        this.makeGauge(fullGaugeName, this.makeMetricName(fullGaugeName), this._storedValueGaugeFactory, segmentCount);
    }

    private String makeGaugeName(String resource, String gaugeName) {
        return "pinot.controller." + resource + "." + gaugeName;
    }

    private MetricName makeMetricName(String gaugeName) {
        return new MetricName(ValidationMetrics.class, gaugeName);
    }

    private void makeGauge(String gaugeName, MetricName metricName, GaugeFactory<?> gaugeFactory, long value) {
        if (!this._gaugeValues.containsKey(gaugeName)) {
            this._gaugeValues.put(gaugeName, value);
            MetricsHelper.newGauge(this._metricsRegistry, metricName, gaugeFactory.buildGauge(gaugeName));
            this._metricNames.add(metricName);
        } else {
            this._gaugeValues.put(gaugeName, value);
        }
    }

    public void unregisterAllMetrics() {
        for (MetricName metricName : this._metricNames) {
            MetricsHelper.removeMetric(this._metricsRegistry, metricName);
        }
        this._metricNames.clear();
        this._gaugeValues.clear();
    }

    private class CurrentTimeMillisDeltaGaugeHoursFactory
    implements GaugeFactory<Double> {
        private CurrentTimeMillisDeltaGaugeHoursFactory() {
        }

        @Override
        public Gauge<Double> buildGauge(String key) {
            return new CurrentTimeMillisDeltaGaugeHours(key);
        }
    }

    private class CurrentTimeMillisDeltaGaugeFactory
    implements GaugeFactory<Long> {
        private CurrentTimeMillisDeltaGaugeFactory() {
        }

        @Override
        public Gauge<Long> buildGauge(String key) {
            return new CurrentTimeMillisDeltaGauge(key);
        }
    }

    private class StoredValueGaugeFactory
    implements GaugeFactory<Long> {
        private StoredValueGaugeFactory() {
        }

        @Override
        public Gauge<Long> buildGauge(String key) {
            return new StoredValueGauge(key);
        }
    }

    private static interface GaugeFactory<T> {
        public Gauge<T> buildGauge(String var1);
    }

    private class CurrentTimeMillisDeltaGaugeHours
    extends Gauge<Double> {
        private final String key;
        private final double MILLIS_PER_HOUR = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);

        public CurrentTimeMillisDeltaGaugeHours(String key) {
            this.key = key;
        }

        @Override
        public Double value() {
            Long gaugeValue = (Long)ValidationMetrics.this._gaugeValues.get(this.key);
            if (gaugeValue != null && gaugeValue != Long.MIN_VALUE) {
                return (double)(System.currentTimeMillis() - gaugeValue) / this.MILLIS_PER_HOUR;
            }
            return Double.MIN_VALUE;
        }
    }

    private class CurrentTimeMillisDeltaGauge
    extends Gauge<Long> {
        private final String key;

        public CurrentTimeMillisDeltaGauge(String key) {
            this.key = key;
        }

        @Override
        public Long value() {
            Long gaugeValue = (Long)ValidationMetrics.this._gaugeValues.get(this.key);
            if (gaugeValue != null && gaugeValue != Long.MIN_VALUE) {
                return System.currentTimeMillis() - gaugeValue;
            }
            return Long.MIN_VALUE;
        }
    }

    private class StoredValueGauge
    extends Gauge<Long> {
        private final String key;

        public StoredValueGauge(String key) {
            this.key = key;
        }

        @Override
        public Long value() {
            return (Long)ValidationMetrics.this._gaugeValues.get(this.key);
        }
    }
}

