/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.partition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.utils.EqualityUtils;

public class PartitionAssignment {
    protected String _tableName;
    protected Map<String, List<String>> _partitionToInstances;

    public PartitionAssignment(String tableName) {
        this._tableName = tableName;
        this._partitionToInstances = new HashMap<String, List<String>>(1);
    }

    public PartitionAssignment(String tableName, Map<String, List<String>> partitionToInstances) {
        this._tableName = tableName;
        this._partitionToInstances = partitionToInstances;
    }

    public String getTableName() {
        return this._tableName;
    }

    public Map<String, List<String>> getPartitionToInstances() {
        return this._partitionToInstances;
    }

    public void addPartition(String partitionName, List<String> instances) {
        this._partitionToInstances.put(partitionName, instances);
    }

    public List<String> getInstancesListForPartition(String partition) {
        return this._partitionToInstances.get(partition);
    }

    public int getNumPartitions() {
        return this._partitionToInstances.size();
    }

    public List<String> getAllInstances() {
        HashSet<String> serverList = new HashSet<String>();
        for (List<String> servers : this.getPartitionToInstances().values()) {
            serverList.addAll(servers);
        }
        return new ArrayList<String>(serverList);
    }

    public String toString() {
        return "PartitionAssignment{_tableName='" + this._tableName + '\'' + ", _partitionToInstances=" + this._partitionToInstances + '}';
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        PartitionAssignment that = (PartitionAssignment)o;
        return EqualityUtils.isEqual(this._tableName, that._tableName) && EqualityUtils.isEqual(this._partitionToInstances, that._partitionToInstances);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._tableName);
        result = EqualityUtils.hashCodeOf(result, this._partitionToInstances);
        return result;
    }
}

