/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.protocols;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.utils.JsonUtils;

public class SegmentCompletionProtocol {
    public static final long MAX_HOLD_TIME_MS = 3000L;
    private static final int DEFAULT_MAX_SEGMENT_COMMIT_TIME_SEC = 120;
    private static long MAX_SEGMENT_COMMIT_TIME_MS = TimeUnit.MILLISECONDS.convert(120L, TimeUnit.SECONDS);
    public static final String STATUS_KEY = "status";
    public static final String OFFSET_KEY = "offset";
    public static final String BUILD_TIME_KEY = "buildTimeSec";
    public static final String COMMIT_TYPE_KEY = "isSplitCommitType";
    public static final String SEGMENT_LOCATION_KEY = "segmentLocation";
    public static final String CONTROLLER_VIP_URL_KEY = "controllerVipUrl";
    public static final String MSG_TYPE_CONSUMED = "segmentConsumed";
    public static final String MSG_TYPE_COMMIT = "segmentCommit";
    public static final String MSG_TYPE_COMMIT_START = "segmentCommitStart";
    public static final String MSG_TYPE_SEGMENT_UPLOAD = "segmentUpload";
    public static final String MSG_TYPE_COMMIT_END = "segmentCommitEnd";
    public static final String MSG_TYPE_STOPPED_CONSUMING = "segmentStoppedConsuming";
    public static final String MSG_TYPE_EXTEND_BUILD_TIME = "extendBuildTime";
    public static final String PARAM_SEGMENT_LOCATION = "location";
    public static final String PARAM_SEGMENT_NAME = "name";
    public static final String PARAM_OFFSET = "offset";
    public static final String PARAM_INSTANCE_ID = "instance";
    public static final String PARAM_MEMORY_USED_BYTES = "memoryUsedBytes";
    public static final String PARAM_SEGMENT_SIZE_BYTES = "segmentSizeBytes";
    public static final String PARAM_REASON = "reason";
    public static final String PARAM_EXTRA_TIME_SEC = "extraTimeSec";
    public static final String PARAM_ROW_COUNT = "rowCount";
    public static final String PARAM_BUILD_TIME_MILLIS = "buildTimeMillis";
    public static final String PARAM_WAIT_TIME_MILLIS = "waitTimeMillis";
    public static final String REASON_ROW_LIMIT = "rowLimit";
    public static final String REASON_TIME_LIMIT = "timeLimit";
    public static final Response RESP_NOT_LEADER = new Response(new Response.Params().withStatus(ControllerResponseStatus.NOT_LEADER));
    public static final Response RESP_FAILED = new Response(new Response.Params().withStatus(ControllerResponseStatus.FAILED));
    public static final Response RESP_DISCARD = new Response(new Response.Params().withStatus(ControllerResponseStatus.DISCARD));
    public static final Response RESP_COMMIT_SUCCESS = new Response(new Response.Params().withStatus(ControllerResponseStatus.COMMIT_SUCCESS));
    public static final Response RESP_COMMIT_CONTINUE = new Response(new Response.Params().withStatus(ControllerResponseStatus.COMMIT_CONTINUE));
    public static final Response RESP_PROCESSED = new Response(new Response.Params().withStatus(ControllerResponseStatus.PROCESSED));
    public static final Response RESP_NOT_SENT = new Response(new Response.Params().withStatus(ControllerResponseStatus.NOT_SENT));
    private static final long MEMORY_USED_BYTES_DEFAULT = -1L;
    private static final int NUM_ROWS_DEFAULT = -1;
    private static final long SEGMENT_SIZE_BYTES_DEFAULT = -1L;
    private static final long BUILD_TIME_MILLIS_DEFAULT = -1L;
    private static final long WAIT_TIME_MILLIS_DEFAULT = -1L;

    public static long getMaxSegmentCommitTimeMs() {
        return MAX_SEGMENT_COMMIT_TIME_MS;
    }

    public static void setMaxSegmentCommitTimeMs(long commitTimeMs) {
        MAX_SEGMENT_COMMIT_TIME_MS = commitTimeMs;
    }

    public static int getDefaultMaxSegmentCommitTimeSeconds() {
        return 120;
    }

    public static class Response {
        private ControllerResponseStatus _status;
        private long _offset = -1L;
        private long _buildTimeSeconds = -1L;
        private boolean _splitCommit;
        private String _segmentLocation;
        private String _controllerVipUrl;

        public Response() {
        }

        public Response(Params params) {
            this._status = params.getStatus();
            this._offset = params.getOffset();
            this._buildTimeSeconds = params.getBuildTimeSeconds();
            this._splitCommit = params.isSplitCommit();
            this._segmentLocation = params.getSegmentLocation();
            this._controllerVipUrl = params.getControllerVipUrl();
        }

        @JsonProperty(value="status")
        public ControllerResponseStatus getStatus() {
            return this._status;
        }

        @JsonProperty(value="status")
        public void setStatus(ControllerResponseStatus status) {
            this._status = status;
        }

        @JsonProperty(value="offset")
        public long getOffset() {
            return this._offset;
        }

        @JsonProperty(value="offset")
        public void setOffset(long offset) {
            this._offset = offset;
        }

        @JsonProperty(value="buildTimeSec")
        public long getBuildTimeSeconds() {
            return this._buildTimeSeconds;
        }

        @JsonProperty(value="buildTimeSec")
        public void setBuildTimeSeconds(long buildTimeSeconds) {
            this._buildTimeSeconds = buildTimeSeconds;
        }

        @JsonProperty(value="isSplitCommitType")
        public boolean isSplitCommit() {
            return this._splitCommit;
        }

        @JsonProperty(value="isSplitCommitType")
        public void setSplitCommit(boolean splitCommit) {
            this._splitCommit = splitCommit;
        }

        @JsonProperty(value="controllerVipUrl")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public String getControllerVipUrl() {
            return this._controllerVipUrl;
        }

        @JsonProperty(value="controllerVipUrl")
        public void setControllerVipUrl(String controllerVipUrl) {
            this._controllerVipUrl = controllerVipUrl;
        }

        @JsonProperty(value="segmentLocation")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public String getSegmentLocation() {
            return this._segmentLocation;
        }

        @JsonProperty(value="segmentLocation")
        public void setSegmentLocation(String segmentLocation) {
            this._segmentLocation = segmentLocation;
        }

        public String toJsonString() {
            try {
                return JsonUtils.objectToString(this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public static Response fromJsonString(String jsonString) {
            try {
                return JsonUtils.stringToObject(jsonString, Response.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public static class Params {
            private ControllerResponseStatus _status = ControllerResponseStatus.FAILED;
            private long _offset = -1L;
            private long _buildTimeSeconds = -1L;
            private boolean _splitCommit = false;
            private String _segmentLocation = null;
            private String _controllerVipUrl = null;

            public Params withOffset(long offset) {
                this._offset = offset;
                return this;
            }

            public Params withStatus(ControllerResponseStatus status) {
                this._status = status;
                return this;
            }

            public Params withBuildTimeSeconds(long buildTimeSeconds) {
                this._buildTimeSeconds = buildTimeSeconds;
                return this;
            }

            public Params withSplitCommit(boolean splitCommit) {
                this._splitCommit = splitCommit;
                return this;
            }

            public Params withControllerVipUrl(String controllerVipUrl) {
                this._controllerVipUrl = controllerVipUrl;
                return this;
            }

            public Params withSegmentLocation(String segmentLocation) {
                this._segmentLocation = segmentLocation;
                return this;
            }

            public ControllerResponseStatus getStatus() {
                return this._status;
            }

            public long getOffset() {
                return this._offset;
            }

            public long getBuildTimeSeconds() {
                return this._buildTimeSeconds;
            }

            public boolean isSplitCommit() {
                return this._splitCommit;
            }

            public String getSegmentLocation() {
                return this._segmentLocation;
            }

            public String getControllerVipUrl() {
                return this._controllerVipUrl;
            }
        }
    }

    public static class SegmentStoppedConsuming
    extends Request {
        public SegmentStoppedConsuming(Request.Params params) {
            super(params, SegmentCompletionProtocol.MSG_TYPE_STOPPED_CONSUMING);
        }
    }

    public static class SegmentCommitEndRequest
    extends Request {
        public SegmentCommitEndRequest(Request.Params params) {
            super(params, SegmentCompletionProtocol.MSG_TYPE_COMMIT_END);
        }
    }

    public static class SegmentCommitUploadRequest
    extends Request {
        public SegmentCommitUploadRequest(Request.Params params) {
            super(params, SegmentCompletionProtocol.MSG_TYPE_SEGMENT_UPLOAD);
        }
    }

    public static class SegmentCommitStartRequest
    extends Request {
        public SegmentCommitStartRequest(Request.Params params) {
            super(params, SegmentCompletionProtocol.MSG_TYPE_COMMIT_START);
        }
    }

    public static class SegmentCommitRequest
    extends Request {
        public SegmentCommitRequest(Request.Params params) {
            super(params, SegmentCompletionProtocol.MSG_TYPE_COMMIT);
        }
    }

    public static class SegmentConsumedRequest
    extends Request {
        public SegmentConsumedRequest(Request.Params params) {
            super(params, SegmentCompletionProtocol.MSG_TYPE_CONSUMED);
        }
    }

    public static class ExtendBuildTimeRequest
    extends Request {
        public ExtendBuildTimeRequest(Request.Params params) {
            super(params, SegmentCompletionProtocol.MSG_TYPE_EXTEND_BUILD_TIME);
        }
    }

    public static abstract class Request {
        final Params _params;
        final String _msgType;

        private Request(Params params, String msgType) {
            this._params = params;
            this._msgType = msgType;
        }

        public String getUrl(String hostPort, String protocol) {
            return protocol + "://" + hostPort + "/" + this._msgType + "?" + SegmentCompletionProtocol.PARAM_SEGMENT_NAME + "=" + this._params.getSegmentName() + "&" + "offset" + "=" + this._params.getOffset() + "&" + SegmentCompletionProtocol.PARAM_INSTANCE_ID + "=" + this._params.getInstanceId() + (this._params.getReason() == null ? "" : "&reason=" + this._params.getReason()) + (this._params.getBuildTimeMillis() <= 0L ? "" : "&buildTimeMillis=" + this._params.getBuildTimeMillis()) + (this._params.getWaitTimeMillis() <= 0L ? "" : "&waitTimeMillis=" + this._params.getWaitTimeMillis()) + (this._params.getExtraTimeSec() <= 0 ? "" : "&extraTimeSec=" + this._params.getExtraTimeSec()) + (this._params.getMemoryUsedBytes() <= 0L ? "" : "&memoryUsedBytes=" + this._params.getMemoryUsedBytes()) + (this._params.getSegmentSizeBytes() <= 0L ? "" : "&segmentSizeBytes=" + this._params.getSegmentSizeBytes()) + (this._params.getNumRows() <= 0 ? "" : "&rowCount=" + this._params.getNumRows()) + (this._params.getSegmentLocation() == null ? "" : "&location=" + this._params.getSegmentLocation());
        }

        public static class Params {
            private long _offset = -1L;
            private String _segmentName = "UNKNOWN_SEGMENT";
            private String _instanceId = "UNKNOWN_INSTANCE";
            private String _reason;
            private int _numRows = -1;
            private long _buildTimeMillis = -1L;
            private long _waitTimeMillis = -1L;
            private int _extraTimeSec = -1;
            private String _segmentLocation = null;
            private long _memoryUsedBytes = -1L;
            private long _segmentSizeBytes = -1L;

            public Params withOffset(long offset) {
                this._offset = offset;
                return this;
            }

            public Params withSegmentName(String segmentName) {
                this._segmentName = segmentName;
                return this;
            }

            public Params withInstanceId(String instanceId) {
                this._instanceId = instanceId;
                return this;
            }

            public Params withReason(String reason) {
                this._reason = reason;
                return this;
            }

            public Params withNumRows(int numRows) {
                this._numRows = numRows;
                return this;
            }

            public Params withBuildTimeMillis(long buildTimeMillis) {
                this._buildTimeMillis = buildTimeMillis;
                return this;
            }

            public Params withWaitTimeMillis(long waitTimeMillis) {
                this._waitTimeMillis = waitTimeMillis;
                return this;
            }

            public Params withExtraTimeSec(int extraTimeSec) {
                this._extraTimeSec = extraTimeSec;
                return this;
            }

            public Params withSegmentLocation(String segmentLocation) {
                this._segmentLocation = segmentLocation;
                return this;
            }

            public Params withMemoryUsedBytes(long memoryUsedBytes) {
                this._memoryUsedBytes = memoryUsedBytes;
                return this;
            }

            public Params withSegmentSizeBytes(long segmentSizeBytes) {
                this._segmentSizeBytes = segmentSizeBytes;
                return this;
            }

            public String getSegmentName() {
                return this._segmentName;
            }

            public long getOffset() {
                return this._offset;
            }

            public String getReason() {
                return this._reason;
            }

            public String getInstanceId() {
                return this._instanceId;
            }

            public int getNumRows() {
                return this._numRows;
            }

            public long getBuildTimeMillis() {
                return this._buildTimeMillis;
            }

            public long getWaitTimeMillis() {
                return this._waitTimeMillis;
            }

            public int getExtraTimeSec() {
                return this._extraTimeSec;
            }

            public String getSegmentLocation() {
                return this._segmentLocation;
            }

            public long getMemoryUsedBytes() {
                return this._memoryUsedBytes;
            }

            public long getSegmentSizeBytes() {
                return this._segmentSizeBytes;
            }

            public String toString() {
                return "Offset: " + this._offset + ",Segment name: " + this._segmentName + ",Instance Id: " + this._instanceId + ",Reason: " + this._reason + ",NumRows: " + this._numRows + ",BuildTimeMillis: " + this._buildTimeMillis + ",WaitTimeMillis: " + this._waitTimeMillis + ",ExtraTimeSec: " + this._extraTimeSec + ",SegmentLocation: " + this._segmentLocation + ",MemoryUsedBytes: " + this._memoryUsedBytes + ",SegmentSizeBytes: " + this._segmentSizeBytes;
            }
        }
    }

    public static enum ControllerResponseStatus {
        NOT_SENT,
        COMMIT,
        HOLD,
        CATCH_UP,
        DISCARD,
        KEEP,
        NOT_LEADER,
        FAILED,
        COMMIT_SUCCESS,
        COMMIT_CONTINUE,
        PROCESSED,
        UPLOAD_SUCCESS;

    }
}

