/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.response;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pinot.$internal.com.google.common.net.InternetDomainName;
import org.apache.pinot.$internal.org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInstance
implements Comparable<ServerInstance> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ServerInstance.class);
    public static final String NAME_PORT_DELIMITER = ":";
    public static final String NAME_PORT_DELIMITER_FOR_INSTANCE_NAME = "_";
    private final String _hostname;
    private final int _port;
    private final InetAddress _ipAddress;
    private final int _seq;
    private final String _shortHostName;
    private static final ConcurrentHashMap<String, Triple<String, String, InetAddress>> nameToInstanceInfo = new ConcurrentHashMap();

    public ServerInstance(String namePortStr) {
        this(namePortStr.split(NAME_PORT_DELIMITER)[0], Integer.parseInt(namePortStr.split(NAME_PORT_DELIMITER)[1]));
    }

    public ServerInstance(String name, int port) {
        this(name, port, 0);
    }

    public ServerInstance(String name, int port, int seq) {
        InetAddress ipAddr = null;
        try {
            ipAddr = InetAddress.getByName(name);
        }
        catch (UnknownHostException e) {
            LOGGER.error("Unable to fetch IpAddresses for host:" + name, (Throwable)e);
            ipAddr = null;
        }
        this._ipAddress = ipAddr;
        this._hostname = this._ipAddress != null ? this._ipAddress.getHostName() : name;
        this._port = port;
        this._seq = seq;
        this._shortHostName = this.makeShortHostName(this._hostname);
    }

    private ServerInstance(String hostname, String shortHostName, InetAddress ipAddress, int port, int seq) {
        this._hostname = hostname;
        this._shortHostName = shortHostName;
        this._ipAddress = ipAddress;
        this._port = port;
        this._seq = seq;
    }

    private String makeShortHostName(String name) {
        try {
            InternetDomainName domainName = InternetDomainName.from(name);
            return (String)domainName.parts().get(0);
        }
        catch (Exception e) {
            return name;
        }
    }

    public String getShortHostName() {
        return this._shortHostName;
    }

    public String getHostname() {
        return this._hostname;
    }

    public int getPort() {
        return this._port;
    }

    public InetAddress getIpAddress() {
        return this._ipAddress;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._hostname == null ? 0 : this._hostname.hashCode());
        result = 31 * result + this._port;
        result = 31 * result + this._seq;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerInstance other = (ServerInstance)obj;
        if (this._hostname == null ? other._hostname != null : !this._hostname.equals(other._hostname)) {
            return false;
        }
        if (this._port != other._port) {
            return false;
        }
        return this._seq == other._seq;
    }

    public ServerInstance withSeq(int seq) {
        return new ServerInstance(this._hostname, this._shortHostName, this._ipAddress, this._port, seq);
    }

    public String toString() {
        return this._hostname + NAME_PORT_DELIMITER_FOR_INSTANCE_NAME + this._port;
    }

    @Override
    public int compareTo(ServerInstance o) {
        return this.toString().compareTo(o.toString());
    }

    public static ServerInstance forHostPort(String name, int port) {
        if (nameToInstanceInfo.containsKey(name)) {
            Triple<String, String, InetAddress> instanceInfo = nameToInstanceInfo.get(name);
            return new ServerInstance(instanceInfo.getLeft(), instanceInfo.getMiddle(), instanceInfo.getRight(), port, 0);
        }
        ServerInstance newInstance = new ServerInstance(name, port);
        nameToInstanceInfo.putIfAbsent(name, Triple.of(newInstance.getHostname(), newInstance.getShortHostName(), newInstance.getIpAddress()));
        return newInstance;
    }

    public static ServerInstance forInstanceName(String instanceName) {
        int port;
        String namePortStr = instanceName.split("Server_")[1];
        String hostName = namePortStr.split(NAME_PORT_DELIMITER_FOR_INSTANCE_NAME)[0];
        try {
            port = Integer.parseInt(namePortStr.split(NAME_PORT_DELIMITER_FOR_INSTANCE_NAME)[1]);
        }
        catch (Exception e) {
            port = 8098;
        }
        return ServerInstance.forHostPort(hostName, port);
    }
}

