/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.segment.fetcher;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.pinot.$internal.com.google.common.base.Strings;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.common.segment.fetcher.SegmentFetcher;
import org.apache.pinot.common.utils.retry.FixedDelayRetryPolicy;
import org.apache.pinot.common.utils.retry.RetryPolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsSegmentFetcher
implements SegmentFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(HdfsSegmentFetcher.class);
    private FileSystem _hadoopFS = null;
    private int _retryCount = 3;
    private int _retryWaitMs = 100;

    @Override
    public void init(Configuration configs) {
        try {
            this._retryCount = configs.getInt("retry.count", this._retryCount);
            this._retryWaitMs = configs.getInt("retry.wait.ms", this._retryWaitMs);
            org.apache.hadoop.conf.Configuration hadoopConf = this.getConf(configs.getString("hadoop.conf.path"));
            this.authenticate(hadoopConf, configs);
            this._hadoopFS = FileSystem.get((org.apache.hadoop.conf.Configuration)hadoopConf);
            LOGGER.info("successfully initialized hdfs segment fetcher");
        }
        catch (Exception e) {
            LOGGER.error("failed to initialized the hdfs segment fetcher", (Throwable)e);
        }
    }

    private org.apache.hadoop.conf.Configuration getConf(String hadoopConfPath) {
        org.apache.hadoop.conf.Configuration hadoopConf = new org.apache.hadoop.conf.Configuration();
        if (Strings.isNullOrEmpty(hadoopConfPath)) {
            LOGGER.warn("no hadoop conf path is provided, will rely on default config");
        } else {
            hadoopConf.addResource(new Path(hadoopConfPath, "core-site.xml"));
            hadoopConf.addResource(new Path(hadoopConfPath, "hdfs-site.xml"));
        }
        return hadoopConf;
    }

    private void authenticate(org.apache.hadoop.conf.Configuration hadoopConf, Configuration configs) {
        String principal = configs.getString("hadoop.kerberos.principle");
        String keytab = configs.getString("hadoop.kerberos.keytab");
        if (!Strings.isNullOrEmpty(principal) && !Strings.isNullOrEmpty(keytab)) {
            UserGroupInformation.setConfiguration((org.apache.hadoop.conf.Configuration)hadoopConf);
            if (UserGroupInformation.isSecurityEnabled()) {
                try {
                    if (!UserGroupInformation.getCurrentUser().hasKerberosCredentials() || !UserGroupInformation.getCurrentUser().getUserName().equals(principal)) {
                        LOGGER.info("Trying to authenticate user [%s] with keytab [%s]..", (Object)principal, (Object)keytab);
                        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Failed to authenticate user principal [%s] with keytab [%s]", principal, keytab), e);
                }
            }
        }
    }

    @Override
    public void fetchSegmentToLocal(String uri, File tempFile) throws Exception {
        LOGGER.debug("starting to fetch segment from hdfs");
        String dstFilePath = tempFile.getAbsolutePath();
        try {
            Path remoteFile = new Path(uri);
            Path localFile = new Path(tempFile.toURI());
            FixedDelayRetryPolicy fixedDelayRetryPolicy = RetryPolicies.fixedDelayRetryPolicy(this._retryCount, this._retryWaitMs);
            fixedDelayRetryPolicy.attempt(() -> {
                try {
                    if (this._hadoopFS == null) {
                        throw new RuntimeException("_hadoopFS client is not initialized when trying to copy files");
                    }
                    long startMs = System.currentTimeMillis();
                    this._hadoopFS.copyToLocalFile(remoteFile, localFile);
                    LOGGER.debug("copied {} from hdfs to {} in local for size {}, take {} ms", new Object[]{uri, dstFilePath, tempFile.length(), System.currentTimeMillis() - startMs});
                    return true;
                }
                catch (IOException e) {
                    LOGGER.warn("failed to fetch segment {} from hdfs, might retry", (Object)uri, (Object)e);
                    return false;
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("failed to fetch {} from hdfs to local {}", new Object[]{uri, dstFilePath, e});
            throw e;
        }
    }

    @Override
    public Set<String> getProtectedConfigKeys() {
        return Collections.emptySet();
    }
}

