/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.segment.fetcher;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.common.exception.HttpErrorStatusException;
import org.apache.pinot.common.segment.fetcher.SegmentFetcher;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.common.utils.retry.RetryPolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSegmentFetcher
implements SegmentFetcher {
    protected final Logger _logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    protected FileUploadDownloadClient _httpClient;
    protected int _retryCount;
    protected int _retryWaitMs;

    @Override
    public void init(Configuration configs) {
        this.initHttpClient(configs);
        this._retryCount = configs.getInt("retry.count", 3);
        this._retryWaitMs = configs.getInt("retry.wait.ms", 100);
    }

    protected void initHttpClient(Configuration configs) {
        this._httpClient = new FileUploadDownloadClient();
    }

    @Override
    public void fetchSegmentToLocal(String uri, File tempFile) throws Exception {
        RetryPolicies.exponentialBackoffRetryPolicy(this._retryCount, this._retryWaitMs, 5.0).attempt(() -> {
            try {
                int statusCode = this._httpClient.downloadFile(new URI(uri), tempFile);
                this._logger.info("Downloaded file from: {} to: {}; Length of downloaded file: {}; Response status code: {}", new Object[]{uri, tempFile, tempFile.length(), statusCode});
                return true;
            }
            catch (HttpErrorStatusException e) {
                int statusCode = e.getStatusCode();
                if (statusCode >= 500) {
                    this._logger.warn("Caught temporary exception while downloading file from: {}, will retry", (Object)uri, (Object)e);
                    return false;
                }
                this._logger.error("Caught permanent exception while downloading file from: {}, won't retry", (Object)uri, (Object)e);
                throw e;
            }
            catch (Exception e) {
                this._logger.warn("Caught temporary exception while downloading file from: {}, will retry", (Object)uri, (Object)e);
                return false;
            }
        });
    }

    @Override
    public Set<String> getProtectedConfigKeys() {
        return Collections.emptySet();
    }
}

