/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSize {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSize.class);
    static final Pattern STORAGE_VAL_PATTERN = Pattern.compile("([\\d.]+)([TGMK])?$", 2);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.##");
    static final Map<String, Long> MULTIPLIER = new HashMap<String, Long>(4);

    public static long toBytes(@Nullable String val) {
        if (val == null) {
            return -1L;
        }
        Matcher matcher = STORAGE_VAL_PATTERN.matcher(val);
        if (!matcher.matches()) {
            return -1L;
        }
        String number = matcher.group(1);
        String unit = matcher.group(2);
        if (unit == null) {
            unit = "B";
        }
        long multiplier = MULTIPLIER.get(unit.toUpperCase());
        BigDecimal bytes = new BigDecimal(number);
        return bytes.multiply(BigDecimal.valueOf(multiplier)).longValue();
    }

    public static String fromBytes(long bytes) {
        if (bytes < MULTIPLIER.get("K")) {
            return String.valueOf(bytes) + "B";
        }
        if (bytes < MULTIPLIER.get("M")) {
            return DECIMAL_FORMAT.format((double)bytes / (double)MULTIPLIER.get("K").longValue()) + "KB";
        }
        if (bytes < MULTIPLIER.get("G")) {
            return DECIMAL_FORMAT.format((double)bytes / (double)MULTIPLIER.get("M").longValue()) + "MB";
        }
        if (bytes < MULTIPLIER.get("T")) {
            return DECIMAL_FORMAT.format((double)bytes / (double)MULTIPLIER.get("G").longValue()) + "GB";
        }
        return DECIMAL_FORMAT.format((double)bytes / (double)MULTIPLIER.get("T").longValue()) + "TB";
    }

    static {
        MULTIPLIER.put("T", 0x10000000000L);
        MULTIPLIER.put("G", 0x40000000L);
        MULTIPLIER.put("M", 0x100000L);
        MULTIPLIER.put("K", 1024L);
        MULTIPLIER.put("B", 1L);
    }
}

