/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Random;
import org.apache.pinot.common.utils.StringUtil;

public class FileUtils {
    private static final Random RANDOM = new Random();

    private FileUtils() {
    }

    public static String getRandomFileName() {
        return StringUtil.join("-", "tmp", String.valueOf(System.currentTimeMillis()), Long.toString(RANDOM.nextLong()));
    }

    public static void moveFileWithOverwrite(File srcFile, File destFile) throws IOException {
        if (destFile.exists()) {
            org.apache.pinot.$internal.org.apache.commons.io.FileUtils.deleteQuietly(destFile);
        }
        org.apache.pinot.$internal.org.apache.commons.io.FileUtils.moveFile(srcFile, destFile);
    }

    public static void transferBytes(FileChannel src, long position, long count, FileChannel dest) throws IOException {
        long numBytesTransferred;
        while ((numBytesTransferred = src.transferTo(position, count, dest)) < count) {
            position += numBytesTransferred;
            count -= numBytesTransferred;
        }
    }
}

