/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.common.data.FieldSpec;

public class JsonUtils {
    public static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    public static final ObjectReader DEFAULT_READER = DEFAULT_MAPPER.reader();
    public static final ObjectWriter DEFAULT_WRITER = DEFAULT_MAPPER.writer();
    public static final ObjectWriter DEFAULT_PRETTY_WRITER = DEFAULT_MAPPER.writerWithDefaultPrettyPrinter();

    private JsonUtils() {
    }

    public static <T> T stringToObject(String jsonString, Class<T> valueType) throws IOException {
        return (T)DEFAULT_MAPPER.readValue(jsonString, valueType);
    }

    public static JsonNode stringToJsonNode(String jsonString) throws IOException {
        return DEFAULT_READER.readTree(jsonString);
    }

    public static <T> T fileToObject(File jsonFile, Class<T> valueType) throws IOException {
        return (T)DEFAULT_MAPPER.readValue(jsonFile, valueType);
    }

    public static JsonNode fileToJsonNode(File jsonFile) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(jsonFile);){
            JsonNode jsonNode = JsonUtils.inputStreamToJsonNode(inputStream);
            return jsonNode;
        }
    }

    public static <T> T inputStreamToObject(InputStream jsonInputStream, Class<T> valueType) throws IOException {
        return (T)DEFAULT_MAPPER.readValue(jsonInputStream, valueType);
    }

    public static JsonNode inputStreamToJsonNode(InputStream jsonInputStream) throws IOException {
        return DEFAULT_READER.readTree(jsonInputStream);
    }

    public static <T> T bytesToObject(byte[] jsonBytes, Class<T> valueType) throws IOException {
        return (T)DEFAULT_MAPPER.readValue(jsonBytes, valueType);
    }

    public static JsonNode bytesToJsonNode(byte[] jsonBytes) throws IOException {
        return JsonUtils.inputStreamToJsonNode(new ByteArrayInputStream(jsonBytes));
    }

    public static <T> T jsonNodeToObject(JsonNode jsonNode, Class<T> valueType) throws JsonProcessingException {
        return (T)DEFAULT_READER.treeToValue((TreeNode)jsonNode, valueType);
    }

    public static String objectToString(Object object) throws JsonProcessingException {
        return DEFAULT_WRITER.writeValueAsString(object);
    }

    public static String objectToPrettyString(Object object) throws JsonProcessingException {
        return DEFAULT_PRETTY_WRITER.writeValueAsString(object);
    }

    public static byte[] objectToBytes(Object object) throws JsonProcessingException {
        return DEFAULT_WRITER.writeValueAsBytes(object);
    }

    public static JsonNode objectToJsonNode(Object object) {
        return DEFAULT_MAPPER.valueToTree(object);
    }

    public static ObjectNode newObjectNode() {
        return JsonNodeFactory.instance.objectNode();
    }

    public static ArrayNode newArrayNode() {
        return JsonNodeFactory.instance.arrayNode();
    }

    public static Object extractValue(@Nullable JsonNode jsonValue, FieldSpec fieldSpec) {
        if (fieldSpec.isSingleValueField()) {
            if (jsonValue != null && !jsonValue.isNull()) {
                return JsonUtils.extractSingleValue(jsonValue, fieldSpec.getDataType());
            }
            return fieldSpec.getDefaultNullValue();
        }
        if (jsonValue != null && !jsonValue.isNull()) {
            if (jsonValue.isArray()) {
                int numValues = jsonValue.size();
                if (numValues != 0) {
                    Object[] values = new Object[numValues];
                    for (int i = 0; i < numValues; ++i) {
                        values[i] = JsonUtils.extractSingleValue(jsonValue.get(i), fieldSpec.getDataType());
                    }
                    return values;
                }
                return new Object[]{fieldSpec.getDefaultNullValue()};
            }
            return new Object[]{JsonUtils.extractSingleValue(jsonValue, fieldSpec.getDataType())};
        }
        return new Object[]{fieldSpec.getDefaultNullValue()};
    }

    private static Object extractSingleValue(JsonNode jsonValue, FieldSpec.DataType dataType) {
        Preconditions.checkArgument(jsonValue.isValueNode());
        switch (dataType) {
            case INT: {
                return jsonValue.asInt();
            }
            case LONG: {
                return jsonValue.asLong();
            }
            case FLOAT: {
                return Float.valueOf((float)jsonValue.asDouble());
            }
            case DOUBLE: {
                return jsonValue.asDouble();
            }
            case STRING: {
                return jsonValue.asText();
            }
        }
        throw new IllegalArgumentException();
    }
}

